/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.tools;

import edu.umd.cs.findbugs.xml.XMLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class ComparePerfomance {
    final int num;
    final Map<String, int[]> performance = new TreeMap<String, int[]>();

    ComparePerfomance(String[] args) throws DocumentException, IOException {
        this.num = args.length;
        for (int i = 0; i < args.length; ++i) {
            this.foo(new File(args[i]), i);
        }
    }

    public int[] getRecord(String className) {
        int[] result = this.performance.get(className);
        if (result != null) {
            return result;
        }
        result = new int[this.num];
        this.performance.put(className, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void foo(File f, int i) throws DocumentException, IOException {
        SAXReader reader = new SAXReader();
        String fName = f.getName();
        try (InputStream in = new FileInputStream(f);){
            if (fName.endsWith(".gz")) {
                in = new GZIPInputStream(in);
            }
            Document doc = reader.read(in);
            Node summary = doc.selectSingleNode("/BugCollection/FindBugsSummary");
            double cpu_seconds = Double.parseDouble(summary.valueOf("@cpu_seconds"));
            this.putStats("cpu_seconds", i, (int)(cpu_seconds * 1000.0));
            double gc_seconds = Double.parseDouble(summary.valueOf("@gc_seconds"));
            this.putStats("gc_seconds", i, (int)(gc_seconds * 1000.0));
            List<Node> profileNodes = XMLUtil.selectNodes(doc, "/BugCollection/FindBugsSummary/FindBugsProfile/ClassProfile");
            for (Node n : profileNodes) {
                String name = n.valueOf("@name");
                int totalMilliseconds = Integer.parseInt(n.valueOf("@totalMilliseconds"));
                int invocations = Integer.parseInt(n.valueOf("@invocations"));
                this.putStats(name, i, totalMilliseconds);
            }
        }
    }

    public void putStats(String name, int i, int totalMilliseconds) {
        int[] stats = this.getRecord(name);
        stats[i] = totalMilliseconds;
    }

    public void print() {
        for (Map.Entry<String, int[]> e : this.performance.entrySet()) {
            String name = e.getKey();
            int lastDot = name.lastIndexOf(46);
            String simpleName = name.substring(lastDot + 1);
            System.out.printf("%s,%s", name, simpleName);
            for (int x : e.getValue()) {
                System.out.printf(",%d", x);
            }
            System.out.println();
        }
    }

    public static void main(String[] args) throws Exception {
        ComparePerfomance p = new ComparePerfomance(args);
        p.print();
    }
}

