/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.tools;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.charsets.SourceCharset;
import edu.umd.cs.findbugs.charsets.UTF8;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.LinkedList;

public class FixIndentation {
    static final String SPACES = "                                                                                                                                            ";
    static final boolean performUpdate = SystemProperties.getBoolean("fix.identation");
    static boolean TRIM_TRAILING_WS = false;
    static int examined = 0;
    static int updated = 0;
    static int lines = 0;

    public static void main(String[] args) throws Exception {
        File root = new File(args[0]);
        if (!root.exists() || !root.canRead()) {
            throw new IllegalArgumentException("Unable to read " + root);
        }
        FixIndentation.recursiveFix(root, true);
        System.out.printf("Updated %d/%d files%n", updated, examined);
        System.out.printf("%d nonblank lines%n", lines);
        if (!performUpdate) {
            System.out.println("No update actually performed");
        }
    }

    static void recursiveFix(File root, boolean partial) throws IOException {
        String rootPath = root.getAbsolutePath();
        HashSet<File> seen = new HashSet<File>();
        LinkedList<File> todo = new LinkedList<File>();
        seen.add(root);
        todo.add(root);
        while (!todo.isEmpty()) {
            File next = ((File)todo.remove()).getAbsoluteFile();
            String nextPath = next.getAbsolutePath();
            if (!nextPath.startsWith(rootPath)) continue;
            if (next.isDirectory()) {
                File[] contents = next.listFiles();
                if (contents == null) continue;
                for (File c : contents) {
                    if (!seen.add(c)) continue;
                    todo.add(c);
                }
                continue;
            }
            if (!nextPath.endsWith(".java") && !nextPath.endsWith(".xml")) continue;
            FixIndentation.fix(next, partial);
        }
    }

    static String fix(String s) {
        int pos;
        if (s.length() == 0) {
            return s;
        }
        if (TRIM_TRAILING_WS && s.trim().length() == 0) {
            return "";
        }
        int indentation = 0;
        int tabs = 0;
        for (pos = 0; pos < s.length(); ++pos) {
            char c = s.charAt(pos);
            if (c == ' ') {
                ++indentation;
                continue;
            }
            if (c != '\t') break;
            indentation += 4;
            ++tabs;
        }
        if (TRIM_TRAILING_WS || tabs > 0) {
            if (pos >= s.length()) {
                return "";
            }
            return SPACES.substring(0, indentation) + s.substring(pos).trim();
        }
        if (pos >= s.length()) {
            return s;
        }
        return SPACES.substring(0, indentation) + s.substring(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fix(File fileToUpdate, boolean partial) throws IOException {
        boolean anyChanges = false;
        BufferedReader in = new BufferedReader(UTF8.fileReader(fileToUpdate));
        ++examined;
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        int consecutiveFixes = 0;
        try {
            String s;
            while ((s = in.readLine()) != null) {
                String s2;
                if (s.trim().length() > 0) {
                    ++lines;
                }
                if (!(s2 = FixIndentation.fix(s)).equals(s)) {
                    if (++consecutiveFixes > 3 && partial) {
                        s2 = s;
                        consecutiveFixes = 0;
                    } else {
                        anyChanges = true;
                    }
                } else {
                    consecutiveFixes = 0;
                }
                out.println(s2);
            }
        }
        finally {
            in.close();
        }
        if (!anyChanges) {
            return;
        }
        ++updated;
        if (!performUpdate) {
            System.out.println("Would update " + fileToUpdate);
            return;
        }
        System.out.println("Updating " + fileToUpdate);
        StringReader stringReader = new StringReader(stringWriter.toString());
        char[] buffer = new char[4000];
        try (Writer outFile = SourceCharset.fileWriter(fileToUpdate);){
            int sz;
            while ((sz = stringReader.read(buffer)) >= 0) {
                outFile.write(buffer, 0, sz);
            }
        }
    }
}

