/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.tools.html;

import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.charsets.UTF8;
import edu.umd.cs.findbugs.tools.html.PrintBugDescriptions;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class PlainPrintBugDescriptions
extends PrintBugDescriptions {
    private final String docTitle;
    private final PrintStream out;

    public PlainPrintBugDescriptions(String docTitle, OutputStream out) {
        this.docTitle = docTitle;
        this.out = UTF8.printStream(out);
    }

    protected String getDocTitle() {
        return this.docTitle;
    }

    protected PrintStream getPrintStream() {
        return this.out;
    }

    @Override
    protected void prologue() throws IOException {
        this.out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html><head><META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n<title>" + this.docTitle + "</title>");
        this.header();
        this.out.println("</head><body>");
        this.beginBody();
        this.out.println("<h1>" + this.docTitle + "</h1>");
    }

    @Override
    protected void emit(BugPattern bugPattern) throws IOException {
        this.out.println("<h2>" + bugPattern.getAbbrev() + ": " + bugPattern.getShortDescription() + "</h2>");
        this.out.println(bugPattern.getDetailText());
    }

    @Override
    protected void epilogue() throws IOException {
        this.endBody();
        this.out.println("</body></html>");
    }

    protected void header() throws IOException {
    }

    protected void beginBody() throws IOException {
    }

    protected void endBody() throws IOException {
    }

    public static void main(String[] args) throws Exception {
        String docTitle = "FindBugs Bug Descriptions";
        if (args.length > 0) {
            docTitle = args[0];
        }
        new PlainPrintBugDescriptions(docTitle, System.out).print();
    }
}

