/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.tools.xml;

import edu.umd.cs.findbugs.xml.XMLUtil;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class CheckMessages {
    private final Set<String> declaredDetectorsSet;
    private final Set<String> declaredAbbrevsSet;

    public CheckMessages(String pluginDescriptorFilename) throws DocumentException {
        XMLFile pluginDescriptorDoc = new XMLFile(pluginDescriptorFilename);
        this.declaredDetectorsSet = pluginDescriptorDoc.collectAttributes("/FindbugsPlugin/Detector", "class");
        this.declaredAbbrevsSet = pluginDescriptorDoc.collectAttributes("/FindbugsPlugin/BugPattern", "abbrev");
    }

    public void checkMessages(XMLFile messagesDoc) throws DocumentException {
        Node node;
        Iterator<Node> i = messagesDoc.xpathIterator("/MessageCollection/Detector");
        while (i.hasNext()) {
            node = i.next();
            messagesDoc.checkAttribute(node, "class");
            messagesDoc.checkElement(node, "Details");
        }
        i = messagesDoc.xpathIterator("/MessageCollection/BugPattern");
        while (i.hasNext()) {
            node = i.next();
            messagesDoc.checkAttribute(node, "type");
            messagesDoc.checkElement(node, "ShortDescription");
            messagesDoc.checkElement(node, "LongDescription");
            messagesDoc.checkElement(node, "Details");
        }
        i = messagesDoc.xpathIterator("/MessageCollection/BugCode");
        while (i.hasNext()) {
            node = i.next();
            messagesDoc.checkAttribute(node, "abbrev");
            messagesDoc.checkNonEmptyText(node);
        }
        Set<String> describedDetectorsSet = messagesDoc.collectAttributes("/MessageCollection/Detector", "class");
        this.checkDescribed("Bug detectors not described by Detector elements", messagesDoc, this.declaredDetectorsSet, describedDetectorsSet);
        Set<String> describedAbbrevsSet = messagesDoc.collectAttributes("/MessageCollection/BugCode", "abbrev");
        this.checkDescribed("Abbreviations not described by BugCode elements", messagesDoc, this.declaredAbbrevsSet, describedAbbrevsSet);
    }

    public void checkDescribed(String description, XMLFile xmlFile, Set<String> declared, Set<String> described) throws DocumentException {
        HashSet<String> notDescribed = new HashSet<String>();
        notDescribed.addAll(declared);
        notDescribed.removeAll(described);
        if (!notDescribed.isEmpty()) {
            throw new CheckMessagesException(description + ": " + ((Object)notDescribed).toString(), xmlFile);
        }
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length < 2) {
            System.err.println("Usage: " + CheckMessages.class.getName() + " <plugin descriptor xml> <bug description xml> [<bug description xml>...]");
            System.exit(1);
        }
        String pluginDescriptor = argv[0];
        try {
            CheckMessages checkMessages = new CheckMessages(pluginDescriptor);
            for (int i = 1; i < argv.length; ++i) {
                String messagesFile = argv[i];
                System.out.println("Checking messages file " + messagesFile);
                checkMessages.checkMessages(new XMLFile(messagesFile));
            }
        }
        catch (DocumentException e) {
            System.err.println("Could not verify messages files: " + e.getMessage());
            System.exit(1);
        }
        System.out.println("Messages files look OK!");
    }

    private static class XMLFile {
        private final String filename;
        private final Document document;

        public XMLFile(String filename) throws DocumentException {
            this.filename = filename;
            File file = new File(filename);
            SAXReader saxReader = new SAXReader();
            this.document = saxReader.read(file);
        }

        public String getFilename() {
            return this.filename;
        }

        public Document getDocument() {
            return this.document;
        }

        public Iterator<Node> xpathIterator(String xpath) {
            List nodes = XMLUtil.selectNodes(this.document, xpath);
            return nodes.iterator();
        }

        public Set<String> collectAttributes(String xpath, String attrName) throws DocumentException {
            HashSet<String> result = new HashSet<String>();
            Iterator<Node> i = this.xpathIterator(xpath);
            while (i.hasNext()) {
                Node node = i.next();
                String value = this.checkAttribute(node, attrName).getValue();
                result.add(value);
            }
            return result;
        }

        public Attribute checkAttribute(Node node, String attrName) throws DocumentException {
            if (!(node instanceof Element)) {
                throw new CheckMessagesException("Node is not an element", this, node);
            }
            Element element = (Element)node;
            Attribute attr = element.attribute(attrName);
            if (attr == null) {
                throw new CheckMessagesException("Missing " + attrName + " attribute", this, node);
            }
            return attr;
        }

        public Element checkElement(Node node, String elementName) throws DocumentException {
            if (!(node instanceof Element)) {
                throw new CheckMessagesException("Node is not an element", this, node);
            }
            Element element = (Element)node;
            Element child = element.element(elementName);
            if (child == null) {
                throw new CheckMessagesException("Missing " + elementName + " element", this, node);
            }
            return child;
        }

        public String checkNonEmptyText(Node node) throws DocumentException {
            if (!(node instanceof Element)) {
                throw new CheckMessagesException("Node is not an element", this, node);
            }
            Element element = (Element)node;
            String text = element.getText();
            if ("".equals(text)) {
                throw new CheckMessagesException("Empty text in element", this, node);
            }
            return text;
        }
    }

    private static class CheckMessagesException
    extends DocumentException {
        private static final long serialVersionUID = 1L;

        public CheckMessagesException(String msg, XMLFile xmlFile, Node node) {
            super("In " + xmlFile.getFilename() + ", " + node.toString() + ": " + msg);
        }

        public CheckMessagesException(String msg, XMLFile xmlFile) {
            super("In " + xmlFile.getFilename() + ": " + msg);
        }
    }
}

