/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugRankCategory;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.charsets.UTF8;
import edu.umd.cs.findbugs.charsets.UserTextFile;
import edu.umd.cs.findbugs.cloud.Cloud;
import edu.umd.cs.findbugs.config.CommandLine;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.DocumentException;

public class CloudSyncAndReport {
    final CSPoptions options;
    final SortedBugCollection bugCollection = new SortedBugCollection();

    public static void main(String[] argv) throws Exception {
        FindBugs.setNoAnalysis();
        CSPoptions options = new CSPoptions();
        CSRCommandLine commandLine = new CSRCommandLine(options);
        int argCount = commandLine.parse(argv, 0, 1, "Usage: " + CloudSyncAndReport.class.getName() + " [options] [<results1> <results2> ... <resultsn>] ");
        if (argCount < argv.length) {
            options.analysisFile = argv[argCount];
        }
        CloudSyncAndReport csr = new CloudSyncAndReport(options);
        csr.load();
        csr.sync();
        PrintWriter out = UTF8.printWriter(System.out);
        csr.report(out);
        out.flush();
        csr.shutdown();
        out.close();
    }

    public CloudSyncAndReport(CSPoptions options) {
        this.options = options;
    }

    public void load() throws IOException, DocumentException {
        if (this.options.analysisFile == null) {
            this.bugCollection.readXML(UTF8.bufferedReader(System.in));
        } else {
            this.bugCollection.readXML(this.options.analysisFile);
        }
        if (this.options.cloudId != null && !this.options.cloudId.equals(this.bugCollection.getProject().getCloudId())) {
            this.bugCollection.getProject().setCloudId(this.options.cloudId);
            this.bugCollection.reinitializeCloud();
        }
    }

    public void sync() {
        Cloud cloud = this.bugCollection.getCloud();
        cloud.initiateCommunication();
        cloud.waitUntilIssueDataDownloaded();
    }

    public void report(PrintWriter out) {
        TreeMap<BugRankCategory, Stats> stats = new TreeMap<BugRankCategory, Stats>();
        ProjectStats projectStats = this.bugCollection.getProjectStats();
        Collection<BugInstance> bugs = this.bugCollection.getCollection();
        Cloud cloud = this.bugCollection.getCloud();
        cloud.setMode(Cloud.Mode.COMMUNAL);
        out.printf("Cloud sync and summary report for %s%n", this.bugCollection.getProject().getProjectName());
        out.printf("Code dated %s%n", new Date(this.bugCollection.getTimestamp()));
        out.printf("Code analyzed %s%n", new Date(this.bugCollection.getAnalysisTimestamp()));
        out.printf("%7d total classes%n", projectStats.getNumClasses());
        out.printf("%7d total issues%n", bugs.size());
        long recentTimestamp = System.currentTimeMillis() - (long)(this.options.ageInHours * 3600) * 1000L;
        int allRecentIssues = 0;
        for (BugInstance b : bugs) {
            Stats s = (Stats)stats.get((Object)BugRankCategory.getRank(b.getBugRank()));
            if (s == null) {
                s = new Stats();
                stats.put(BugRankCategory.getRank(b.getBugRank()), s);
            }
            ++s.total;
            long firstSeen = cloud.getFirstSeen(b);
            if (firstSeen <= recentTimestamp) continue;
            ++s.recent;
            ++allRecentIssues;
        }
        out.printf("%7d recent issues%n", allRecentIssues);
        if (this.options.cloudSummary != null && cloud.supportsCloudSummaries()) {
            try {
                PrintWriter cs = UserTextFile.printWriter(this.options.cloudSummary);
                cs.printf("%6s %6s %s%n", "recent", "total", "Rank category");
                for (Map.Entry e : stats.entrySet()) {
                    Stats s = (Stats)e.getValue();
                    if (s.total <= 0) continue;
                    cs.printf("%6d %6d %s%n", s.recent, s.total, e.getKey());
                }
                cs.println();
                cloud.printCloudSummary(cs, bugs, null);
                cs.close();
            }
            catch (Exception e) {
                out.println("Error writing cloud summary to " + this.options.cloudSummary);
                e.printStackTrace(out);
            }
        }
    }

    public void shutdown() {
        Cloud cloud = this.bugCollection.getCloud();
        cloud.shutdown();
    }

    static class Stats {
        int total;
        int recent;

        Stats() {
        }
    }

    static class CSRCommandLine
    extends CommandLine {
        final CSPoptions options;

        public CSRCommandLine(CSPoptions options) {
            this.options = options;
            this.addOption("-cloud", "id", "id of the cloud to use");
            this.addOption("-recent", "hours", "maximum age in hours for an issue to be recent");
            this.addOption("-cloudSummary", "file", "write a cloud summary to thie file");
        }

        @Override
        protected void handleOption(String option, String optionExtraPart) throws IOException {
            throw new IllegalArgumentException("Unknown option : " + option);
        }

        @Override
        protected void handleOptionWithArgument(String option, String argument) throws IOException {
            if ("-cloud".equals(option)) {
                this.options.cloudId = argument;
            } else if ("-recent".equals(option)) {
                this.options.ageInHours = Integer.parseInt(argument);
            } else if ("-cloudSummary".equals(option)) {
                this.options.cloudSummary = argument;
            } else {
                throw new IllegalArgumentException("Unknown option : " + option);
            }
        }
    }

    public static class CSPoptions {
        public String analysisFile;
        public String cloudSummary;
        public String cloudId;
        public int ageInHours = 22;
    }
}

