/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.Visitor;

public final class ConstantInvokeDynamic
extends Constant {
    private static final long serialVersionUID = 4310367359017396174L;
    private int bootstrap_method_attr_index;
    private int name_and_type_index;

    public ConstantInvokeDynamic(ConstantInvokeDynamic c) {
        this(c.getBootstrapMethodAttrIndex(), c.getNameAndTypeIndex());
    }

    ConstantInvokeDynamic(DataInput file) throws IOException {
        this(file.readUnsignedShort(), file.readUnsignedShort());
    }

    public ConstantInvokeDynamic(int bootstrap_method_attr_index, int name_and_type_index) {
        super((byte)18);
        this.bootstrap_method_attr_index = bootstrap_method_attr_index;
        this.name_and_type_index = name_and_type_index;
    }

    public void accept(Visitor v) {
    }

    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(this.tag);
        file.writeShort(this.bootstrap_method_attr_index);
        file.writeShort(this.name_and_type_index);
    }

    public int getBootstrapMethodAttrIndex() {
        return this.bootstrap_method_attr_index;
    }

    public void setBootstrapMethodAttrIndex(int bootstrap_method_attr_index) {
        this.bootstrap_method_attr_index = bootstrap_method_attr_index;
    }

    public int getNameAndTypeIndex() {
        return this.name_and_type_index;
    }

    public void setNameAndTypeIndex(int name_and_type_index) {
        this.name_and_type_index = name_and_type_index;
    }

    public final String toString() {
        return super.toString() + "(bootstrap_method_attr_index = " + this.bootstrap_method_attr_index + ", name_and_type_index = " + this.name_and_type_index + ")";
    }
}

