/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.util.BitSet;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;

public final class IgniteFeatures
extends Enum<IgniteFeatures> {
    public static final /* enum */ IgniteFeatures TCP_COMMUNICATION_SPI_HANDSHAKE_WAIT_MESSAGE = new IgniteFeatures(0);
    public static final /* enum */ IgniteFeatures CACHE_METRICS_V2 = new IgniteFeatures(1);
    public static final /* enum */ IgniteFeatures DATA_PACKET_COMPRESSION = new IgniteFeatures(3);
    public static final /* enum */ IgniteFeatures DIFFERENT_REBALANCE_POOL_SIZE = new IgniteFeatures(4);
    public static final /* enum */ IgniteFeatures SPLITTED_CACHE_CONFIGURATIONS = new IgniteFeatures(5);
    public static final /* enum */ IgniteFeatures TRANSACTION_OWNER_THREAD_DUMP_PROVIDING = new IgniteFeatures(6);
    public static final /* enum */ IgniteFeatures TX_INFO_COMMAND = new IgniteFeatures(7);
    public static final /* enum */ IgniteFeatures FIND_AND_DELETE_GARBAGE_COMMAND = new IgniteFeatures(8);
    public static final /* enum */ IgniteFeatures SUSPEND_RESUME_PESSIMISTIC_TX = new IgniteFeatures(10);
    public static final /* enum */ IgniteFeatures DISTRIBUTED_METASTORAGE = new IgniteFeatures(11);
    public static final /* enum */ IgniteFeatures CHANNEL_COMMUNICATION = new IgniteFeatures(12);
    public static final /* enum */ IgniteFeatures TCP_DISCOVERY_MESSAGE_NODE_COMPACT_REPRESENTATION = new IgniteFeatures(14);
    public static final /* enum */ IgniteFeatures LRT_SYSTEM_USER_TIME_DUMP_SETTINGS = new IgniteFeatures(18);
    public static final /* enum */ IgniteFeatures PME_FREE_SWITCH = new IgniteFeatures(19);
    private final int featureId;
    private static final /* synthetic */ IgniteFeatures[] $VALUES;

    public static IgniteFeatures[] values() {
        return (IgniteFeatures[])$VALUES.clone();
    }

    public static IgniteFeatures valueOf(String name) {
        return Enum.valueOf(IgniteFeatures.class, name);
    }

    private IgniteFeatures(int featureId) {
        this.featureId = featureId;
    }

    public int getFeatureId() {
        return this.featureId;
    }

    public static boolean nodeSupports(ClusterNode clusterNode, IgniteFeatures feature) {
        byte[] features = (byte[])clusterNode.attribute("org.apache.ignite.features");
        if (features == null) {
            return false;
        }
        return IgniteFeatures.nodeSupports(features, feature);
    }

    public static boolean nodeSupports(byte[] featuresAttrBytes, IgniteFeatures feature) {
        int featureId = feature.getFeatureId();
        int byteIdx = featureId >>> 3;
        if (byteIdx >= featuresAttrBytes.length) {
            return false;
        }
        int bitIdx = featureId & 7;
        return (featuresAttrBytes[byteIdx] & 1 << bitIdx) != 0;
    }

    public static boolean allNodesSupports(Iterable<ClusterNode> nodes, IgniteFeatures feature) {
        for (ClusterNode next : nodes) {
            if (IgniteFeatures.nodeSupports(next, feature)) continue;
            return false;
        }
        return true;
    }

    public static byte[] allFeatures() {
        BitSet set = new BitSet();
        for (IgniteFeatures value : IgniteFeatures.values()) {
            if (value == PME_FREE_SWITCH && IgniteSystemProperties.getBoolean("IGNITE_PME_FREE_SWITCH_DISABLED")) continue;
            int featureId = value.getFeatureId();
            assert (!set.get(featureId)) : "Duplicate feature ID found for [" + (Object)((Object)value) + "] having same ID [" + featureId + "]";
            set.set(featureId);
        }
        return set.toByteArray();
    }

    static {
        $VALUES = new IgniteFeatures[]{TCP_COMMUNICATION_SPI_HANDSHAKE_WAIT_MESSAGE, CACHE_METRICS_V2, DATA_PACKET_COMPRESSION, DIFFERENT_REBALANCE_POOL_SIZE, SPLITTED_CACHE_CONFIGURATIONS, TRANSACTION_OWNER_THREAD_DUMP_PROVIDING, TX_INFO_COMMAND, FIND_AND_DELETE_GARBAGE_COMMAND, SUSPEND_RESUME_PESSIMISTIC_TX, DISTRIBUTED_METASTORAGE, CHANNEL_COMMUNICATION, TCP_DISCOVERY_MESSAGE_NODE_COMPACT_REPRESENTATION, LRT_SYSTEM_USER_TIME_DUMP_SETTINGS, PME_FREE_SWITCH};
    }
}

