/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxPrepareResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.CacheVersionedValue;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridNearTxPrepareResponse
extends GridDistributedTxPrepareResponse {
    private static final long serialVersionUID = 0L;
    private static final int NEAR_PREPARE_ONE_PHASE_COMMIT_FLAG_MASK = 1;
    @GridToStringInclude
    @GridDirectCollection(value=GridCacheVersion.class)
    private Collection<GridCacheVersion> pending;
    private IgniteUuid futId;
    private int miniId;
    private GridCacheVersion dhtVer;
    private GridCacheVersion writeVer;
    @GridToStringInclude
    @GridDirectTransient
    private Map<IgniteTxKey, CacheVersionedValue> ownedVals;
    @GridToStringExclude
    @GridDirectCollection(value=IgniteTxKey.class)
    private Collection<IgniteTxKey> ownedValKeys;
    @GridToStringExclude
    @GridDirectCollection(value=CacheVersionedValue.class)
    private Collection<CacheVersionedValue> ownedValVals;
    private GridCacheReturn retVal;
    @GridDirectCollection(value=IgniteTxKey.class)
    private Collection<IgniteTxKey> filterFailedKeys;
    private AffinityTopologyVersion clientRemapVer;

    public GridNearTxPrepareResponse() {
    }

    public GridNearTxPrepareResponse(int part, GridCacheVersion xid, IgniteUuid futId, int miniId, GridCacheVersion dhtVer, GridCacheVersion writeVer, GridCacheReturn retVal, Throwable err, AffinityTopologyVersion clientRemapVer, boolean onePhaseCommit, boolean addDepInfo) {
        super(part, xid, err, addDepInfo);
        assert (futId != null);
        assert (dhtVer != null);
        this.futId = futId;
        this.miniId = miniId;
        this.dhtVer = dhtVer;
        this.writeVer = writeVer;
        this.retVal = retVal;
        this.clientRemapVer = clientRemapVer;
        if (onePhaseCommit) {
            this.flags = (byte)(this.flags | 1);
        }
    }

    public boolean onePhaseCommit() {
        return this.isFlag(1);
    }

    @Nullable
    AffinityTopologyVersion clientRemapVersion() {
        return this.clientRemapVer;
    }

    public Collection<GridCacheVersion> pending() {
        return this.pending == null ? Collections.emptyList() : this.pending;
    }

    public void pending(Collection<GridCacheVersion> pending) {
        this.pending = pending;
    }

    public int miniId() {
        return this.miniId;
    }

    public IgniteUuid futureId() {
        return this.futId;
    }

    public GridCacheVersion dhtVersion() {
        return this.dhtVer;
    }

    public GridCacheVersion writeVersion() {
        return this.writeVer;
    }

    public void addOwnedValue(IgniteTxKey key, GridCacheVersion ver, CacheObject val) {
        if (val == null) {
            return;
        }
        if (this.ownedVals == null) {
            this.ownedVals = new HashMap<IgniteTxKey, CacheVersionedValue>();
        }
        CacheVersionedValue oVal = new CacheVersionedValue(val, ver);
        this.ownedVals.put(key, oVal);
    }

    public Map<IgniteTxKey, CacheVersionedValue> ownedValues() {
        return this.ownedVals == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.ownedVals);
    }

    public GridCacheReturn returnValue() {
        return this.retVal;
    }

    public void filterFailedKeys(Collection<IgniteTxKey> filterFailedKeys) {
        this.filterFailedKeys = filterFailedKeys;
    }

    public Collection<IgniteTxKey> filterFailedKeys() {
        return this.filterFailedKeys == null ? Collections.emptyList() : this.filterFailedKeys;
    }

    public boolean hasOwnedValue(IgniteTxKey key) {
        return this.ownedVals != null && this.ownedVals.containsKey(key);
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        if (this.ownedVals != null && this.ownedValKeys == null) {
            this.ownedValKeys = this.ownedVals.keySet();
            this.ownedValVals = this.ownedVals.values();
            for (Map.Entry entry : this.ownedVals.entrySet()) {
                GridCacheContext cacheCtx = ctx.cacheContext(((IgniteTxKey)entry.getKey()).cacheId());
                ((IgniteTxKey)entry.getKey()).prepareMarshal(cacheCtx);
                ((CacheVersionedValue)entry.getValue()).prepareMarshal(cacheCtx.cacheObjectContext());
            }
        }
        if (this.retVal != null && this.retVal.cacheId() != 0) {
            GridCacheContext cctx = ctx.cacheContext(this.retVal.cacheId());
            assert (cctx != null) : this.retVal.cacheId();
            this.retVal.prepareMarshal(cctx);
        }
        if (this.filterFailedKeys != null) {
            for (IgniteTxKey igniteTxKey : this.filterFailedKeys) {
                GridCacheContext cctx = ctx.cacheContext(igniteTxKey.cacheId());
                igniteTxKey.prepareMarshal(cctx);
            }
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.ownedValKeys != null && this.ownedVals == null) {
            this.ownedVals = U.newHashMap(this.ownedValKeys.size());
            assert (this.ownedValKeys.size() == this.ownedValVals.size());
            Iterator<IgniteTxKey> keyIter = this.ownedValKeys.iterator();
            Iterator<CacheVersionedValue> valIter = this.ownedValVals.iterator();
            while (keyIter.hasNext()) {
                IgniteTxKey key = keyIter.next();
                GridCacheContext cctx = ctx.cacheContext(key.cacheId());
                CacheVersionedValue val = valIter.next();
                key.finishUnmarshal(cctx, ldr);
                val.finishUnmarshal(cctx, ldr);
                this.ownedVals.put(key, val);
            }
        }
        if (this.retVal != null && this.retVal.cacheId() != 0) {
            GridCacheContext cctx = ctx.cacheContext(this.retVal.cacheId());
            assert (cctx != null) : this.retVal.cacheId();
            this.retVal.finishUnmarshal(cctx, ldr);
        }
        if (this.filterFailedKeys != null) {
            for (IgniteTxKey key : this.filterFailedKeys) {
                GridCacheContext cctx = ctx.cacheContext(key.cacheId());
                key.finishUnmarshal(cctx, ldr);
            }
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 11: {
                if (!writer.writeAffinityTopologyVersion("clientRemapVer", this.clientRemapVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeMessage("dhtVer", this.dhtVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeCollection("filterFailedKeys", this.filterFailedKeys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeIgniteUuid("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 15: {
                if (!writer.writeInt("miniId", this.miniId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 16: {
                if (!writer.writeCollection("ownedValKeys", this.ownedValKeys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 17: {
                if (!writer.writeCollection("ownedValVals", this.ownedValVals, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 18: {
                if (!writer.writeCollection("pending", this.pending, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 19: {
                if (!writer.writeMessage("retVal", this.retVal)) {
                    return false;
                }
                writer.incrementState();
            }
            case 20: {
                if (!writer.writeMessage("writeVer", this.writeVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 11: {
                this.clientRemapVer = reader.readAffinityTopologyVersion("clientRemapVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.dhtVer = (GridCacheVersion)reader.readMessage("dhtVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.filterFailedKeys = reader.readCollection("filterFailedKeys", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 14: {
                this.futId = reader.readIgniteUuid("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 15: {
                this.miniId = reader.readInt("miniId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 16: {
                this.ownedValKeys = reader.readCollection("ownedValKeys", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 17: {
                this.ownedValVals = reader.readCollection("ownedValVals", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 18: {
                this.pending = reader.readCollection("pending", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 19: {
                this.retVal = (GridCacheReturn)reader.readMessage("retVal");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 20: {
                this.writeVer = (GridCacheVersion)reader.readMessage("writeVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridNearTxPrepareResponse.class);
    }

    @Override
    public short directType() {
        return 56;
    }

    @Override
    public byte fieldsCount() {
        return 21;
    }

    @Override
    public String toString() {
        return S.toString(GridNearTxPrepareResponse.class, this, "super", super.toString());
    }
}

