/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.aware;

import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.wal.aware.SegmentArchivedStorage;

class SegmentCurrentStateStorage {
    private volatile boolean interrupted;
    private volatile boolean forceInterrupted;
    private final int walSegmentsCnt;
    private final SegmentArchivedStorage segmentArchivedStorage;
    private volatile long curAbsWalIdx = -1L;

    private SegmentCurrentStateStorage(int walSegmentsCnt, SegmentArchivedStorage segmentArchivedStorage) {
        this.walSegmentsCnt = walSegmentsCnt;
        this.segmentArchivedStorage = segmentArchivedStorage;
    }

    static SegmentCurrentStateStorage buildCurrentStateStorage(int walSegmentsCnt, SegmentArchivedStorage segmentArchivedStorage) {
        SegmentCurrentStateStorage currStorage = new SegmentCurrentStateStorage(walSegmentsCnt, segmentArchivedStorage);
        segmentArchivedStorage.addObserver(currStorage::onSegmentArchived);
        return currStorage;
    }

    synchronized void awaitSegment(long absSegIdx) throws IgniteInterruptedCheckedException {
        try {
            while (this.curAbsWalIdx < absSegIdx && !this.interrupted) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedCheckedException(e);
        }
        this.checkInterrupted();
    }

    synchronized long waitNextSegmentForArchivation() throws IgniteInterruptedCheckedException {
        long lastArchivedSegment = this.segmentArchivedStorage.lastArchivedAbsoluteIndex();
        this.awaitSegment(lastArchivedSegment + 2L);
        return lastArchivedSegment + 1L;
    }

    synchronized long nextAbsoluteSegmentIndex() throws IgniteInterruptedCheckedException {
        ++this.curAbsWalIdx;
        this.notifyAll();
        try {
            while (this.curAbsWalIdx - this.segmentArchivedStorage.lastArchivedAbsoluteIndex() > (long)this.walSegmentsCnt && !this.forceInterrupted) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedCheckedException(e);
        }
        if (this.forceInterrupted) {
            throw new IgniteInterruptedCheckedException("Interrupt waiting of change archived idx");
        }
        return this.curAbsWalIdx;
    }

    synchronized void curAbsWalIdx(long curAbsWalIdx) {
        this.curAbsWalIdx = curAbsWalIdx;
        this.notifyAll();
    }

    long curAbsWalIdx() {
        return this.curAbsWalIdx;
    }

    synchronized void interrupt() {
        this.interrupted = true;
        this.notifyAll();
    }

    synchronized void forceInterrupt() {
        this.interrupted = true;
        this.forceInterrupted = true;
        this.notifyAll();
    }

    private synchronized void onSegmentArchived(long lastAbsArchivedIdx) {
        this.notifyAll();
    }

    private void checkInterrupted() throws IgniteInterruptedCheckedException {
        if (this.interrupted) {
            throw new IgniteInterruptedCheckedException("Interrupt waiting of change current idx");
        }
    }

    public void reset() {
        this.interrupted = false;
        this.forceInterrupted = false;
    }
}

