/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.diagnostic;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileDescriptor;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.SegmentRouter;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.IgniteWalIteratorFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.scanner.ScannerHandler;
import org.apache.ignite.internal.processors.cache.persistence.wal.scanner.ScannerHandlers;
import org.apache.ignite.internal.processors.cache.persistence.wal.scanner.WalScanner;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializerFactoryImpl;
import org.apache.ignite.internal.processors.diagnostic.DiagnosticProcessor;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.T2;
import org.jetbrains.annotations.NotNull;

public class PageHistoryDiagnoster {
    @GridToStringExclude
    protected final GridKernalContext ctx;
    @GridToStringExclude
    protected final IgniteLogger log;
    private File[] walFolders;
    private final BiFunction<File, DiagnosticProcessor.DiagnosticFileWriteMode, File> targetFileSupplier;
    private final IgniteWalIteratorFactory iteratorFactory = new IgniteWalIteratorFactory();
    private volatile FileWriteAheadLogManager wal;

    public PageHistoryDiagnoster(GridKernalContext ctx, BiFunction<File, DiagnosticProcessor.DiagnosticFileWriteMode, File> supplier) {
        this.log = ctx.log(this.getClass());
        this.ctx = ctx;
        this.targetFileSupplier = supplier;
    }

    public void onStart() {
        FileWriteAheadLogManager wal = (FileWriteAheadLogManager)this.ctx.cache().context().wal();
        if (wal == null) {
            return;
        }
        this.wal = wal;
        SegmentRouter segmentRouter = wal.getSegmentRouter();
        this.walFolders = segmentRouter.hasArchive() ? new File[]{segmentRouter.getWalArchiveDir(), segmentRouter.getWalWorkDir()} : new File[]{segmentRouter.getWalWorkDir()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpPageHistory(@NotNull DiagnosticPageBuilder builder) throws IgniteCheckedException {
        List<T2<Long, Long>> gaps;
        if (this.walFolders == null) {
            this.log.info("Skipping dump page history due to WAL not configured");
            return;
        }
        ScannerHandler action = null;
        for (DiagnosticProcessor.DiagnosticAction act : builder.actions) {
            if (action == null) {
                action = this.toHandler(act, builder.dumpFolder);
                continue;
            }
            action = action.andThen(this.toHandler(act, builder.dumpFolder));
        }
        Objects.requireNonNull(action, "Should be configured at least one action");
        IgniteWalIteratorFactory.IteratorParametersBuilder params = IgniteWalIteratorFactory.IteratorParametersBuilder.withIteratorParameters().log(this.log).filesOrDirs(this.walFolders);
        List<FileDescriptor> descs = this.iteratorFactory.resolveWalFiles(params);
        int descIdx = -1;
        FileWALPointer reserved = null;
        for (int i = 0; i < descs.size(); ++i) {
            reserved = new FileWALPointer(descs.get(i).idx(), 0, 0);
            if (!this.wal.reserve(reserved)) continue;
            descIdx = i;
            break;
        }
        if (descIdx == -1) {
            this.log.info("Skipping dump page history due to can not reserve WAL segments: " + this.descToString(descs));
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Reserverd WAL segment idx: " + reserved.index());
        }
        if (!(gaps = this.iteratorFactory.hasGaps(descs.subList(descIdx, descs.size()))).isEmpty()) {
            this.log.warning("Potentialy missed record because WAL has gaps: " + this.gapsToString(gaps));
        }
        try {
            this.scan(builder, params, action, reserved);
        }
        finally {
            assert (reserved != null);
            this.wal.release(reserved);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Release WAL segment idx:" + reserved.index());
            }
        }
    }

    private void scan(DiagnosticPageBuilder builder, IgniteWalIteratorFactory.IteratorParametersBuilder params, ScannerHandler action, FileWALPointer from) throws IgniteCheckedException {
        try {
            WalScanner.buildWalScanner(this.wal.replay(from)).findAllRecordsFor(builder.pageIds).forEach(action);
            return;
        }
        catch (IgniteCheckedException e) {
            this.log.warning("Failed to diagnosric scan via WAL manager", e);
            WalScanner.ScanTerminateStep scanner = WalScanner.buildWalScanner(params.from(from)).findAllRecordsFor(builder.pageIds);
            scanner.forEach(action);
            return;
        }
    }

    private String descToString(List<FileDescriptor> descs) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Iterator<FileDescriptor> iter = descs.iterator();
        while (iter.hasNext()) {
            FileDescriptor desc = iter.next();
            sb.append(desc.idx());
            if (iter.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    private String gapsToString(Collection<T2<Long, Long>> gaps) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Iterator<T2<Long, Long>> iter = gaps.iterator();
        while (iter.hasNext()) {
            T2<Long, Long> gap = iter.next();
            sb.append("(").append(gap.get1()).append("..").append(gap.get2()).append(")");
            if (iter.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    private ScannerHandler toHandler(DiagnosticProcessor.DiagnosticAction action, File customFile) {
        switch (action) {
            case PRINT_TO_LOG: {
                return ScannerHandlers.printToLog(this.log);
            }
            case PRINT_TO_FILE: {
                return ScannerHandlers.printToFile(this.targetFileSupplier.apply(customFile, DiagnosticProcessor.DiagnosticFileWriteMode.HUMAN_READABLE));
            }
            case PRINT_TO_RAW_FILE: {
                return ScannerHandlers.printRawToFile(this.targetFileSupplier.apply(customFile, DiagnosticProcessor.DiagnosticFileWriteMode.RAW), this.serializer());
            }
        }
        throw new IllegalArgumentException("Unknown diagnostic action : " + (Object)((Object)action));
    }

    private RecordSerializer serializer() {
        GridCacheSharedContext cctx = this.ctx.cache().context();
        int serializerVer = cctx.wal().serializerVersion();
        try {
            return new RecordSerializerFactoryImpl(cctx).createSerializer(serializerVer);
        }
        catch (IgniteCheckedException e) {
            this.log.error("Failed to create WAL records serializer for diagnostic purposes [serializerVer=" + serializerVer + "]");
            throw new IgniteException(e);
        }
    }

    public static class DiagnosticPageBuilder {
        List<T2<Integer, Long>> pageIds = new ArrayList<T2<Integer, Long>>();
        Set<DiagnosticProcessor.DiagnosticAction> actions = EnumSet.noneOf(DiagnosticProcessor.DiagnosticAction.class);
        File dumpFolder;

        public DiagnosticPageBuilder pageIds(T2<Integer, Long> ... pageIds) {
            this.pageIds.addAll(Arrays.asList(pageIds));
            return this;
        }

        public DiagnosticPageBuilder addAction(@NotNull DiagnosticProcessor.DiagnosticAction action) {
            this.actions.add(action);
            return this;
        }

        public DiagnosticPageBuilder folderForDump(@NotNull File file) {
            this.dumpFolder = file;
            return this;
        }
    }
}

