/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs.client;

import java.util.Collection;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.igfs.IgfsBlockLocation;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.internal.processors.igfs.IgfsContext;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientAbstractCallable;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class IgfsClientAffinityCallable
extends IgfsClientAbstractCallable<Collection<IgfsBlockLocation>> {
    private static final long serialVersionUID = 0L;
    private long start;
    private long len;
    private long maxLen;

    public IgfsClientAffinityCallable() {
    }

    public IgfsClientAffinityCallable(@Nullable String igfsName, @Nullable String user, IgfsPath path, long start, long len, long maxLen) {
        super(igfsName, user, path);
        this.start = start;
        this.len = len;
        this.maxLen = maxLen;
    }

    @Override
    protected Collection<IgfsBlockLocation> call0(IgfsContext ctx) throws Exception {
        return ctx.igfs().affinity(this.path, this.start, this.len, this.maxLen);
    }

    @Override
    public void writeBinary0(BinaryRawWriter writer) throws BinaryObjectException {
        writer.writeLong(this.start);
        writer.writeLong(this.len);
        writer.writeLong(this.maxLen);
    }

    @Override
    public void readBinary0(BinaryRawReader reader) throws BinaryObjectException {
        this.start = reader.readLong();
        this.len = reader.readLong();
        this.maxLen = reader.readLong();
    }

    public String toString() {
        return S.toString(IgfsClientAffinityCallable.class, this);
    }
}

