/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs.client;

import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.internal.processors.igfs.IgfsContext;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientAbstractCallable;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class IgfsClientSetTimesCallable
extends IgfsClientAbstractCallable<Void> {
    private static final long serialVersionUID = 0L;
    private long accessTime;
    private long modificationTime;

    public IgfsClientSetTimesCallable() {
    }

    public IgfsClientSetTimesCallable(@Nullable String igfsName, @Nullable String user, IgfsPath path, long accessTime, long modificationTime) {
        super(igfsName, user, path);
        this.accessTime = accessTime;
        this.modificationTime = modificationTime;
    }

    @Override
    protected Void call0(IgfsContext ctx) throws Exception {
        ctx.igfs().setTimes(this.path, this.modificationTime, this.accessTime);
        return null;
    }

    @Override
    public void writeBinary0(BinaryRawWriter writer) throws BinaryObjectException {
        writer.writeLong(this.accessTime);
        writer.writeLong(this.modificationTime);
    }

    @Override
    public void readBinary0(BinaryRawReader reader) throws BinaryObjectException {
        this.accessTime = reader.readLong();
        this.modificationTime = reader.readLong();
    }

    public String toString() {
        return S.toString(IgfsClientSetTimesCallable.class, this);
    }
}

