/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResult;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcBatchExecuteResult
extends JdbcResult {
    private int[] updateCnts;
    private int errCode;
    private String errMsg;

    JdbcBatchExecuteResult() {
        super((byte)6);
    }

    JdbcBatchExecuteResult(byte type) {
        super(type);
    }

    JdbcBatchExecuteResult(int[] updateCnts, int errCode, String errMsg) {
        super((byte)6);
        this.updateCnts = updateCnts;
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    JdbcBatchExecuteResult(byte type, JdbcBatchExecuteResult res) {
        super(type);
        this.updateCnts = res.updateCnts;
        this.errCode = res.errCode;
        this.errMsg = res.errMsg;
    }

    public int[] updateCounts() {
        return this.updateCnts;
    }

    public int errorCode() {
        return this.errCode;
    }

    public String errorMessage() {
        return this.errMsg;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        super.writeBinary(writer, ver);
        writer.writeInt(this.errCode);
        writer.writeString(this.errMsg);
        writer.writeIntArray(this.updateCnts);
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        super.readBinary(reader, ver);
        this.errCode = reader.readInt();
        this.errMsg = reader.readString();
        this.updateCnts = reader.readIntArray();
    }

    @Override
    public String toString() {
        return S.toString(JdbcBatchExecuteResult.class, this, super.toString());
    }
}

