/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.cluster;

import java.util.Collection;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.GridRestCommandHandlerAdapter;
import org.apache.ignite.internal.processors.rest.request.GridRestChangeStateRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridChangeStateCommandHandler
extends GridRestCommandHandlerAdapter {
    private static final Collection<GridRestCommand> commands = U.sealList(GridRestCommand.CLUSTER_ACTIVATE, GridRestCommand.CLUSTER_DEACTIVATE, GridRestCommand.CLUSTER_CURRENT_STATE, GridRestCommand.CLUSTER_ACTIVE, GridRestCommand.CLUSTER_INACTIVE);

    public GridChangeStateCommandHandler(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public Collection<GridRestCommand> supportedCommands() {
        return commands;
    }

    @Override
    public IgniteInternalFuture<GridRestResponse> handleAsync(GridRestRequest restRest) {
        GridRestChangeStateRequest req = (GridRestChangeStateRequest)restRest;
        GridFutureAdapter<GridRestResponse> fut = new GridFutureAdapter<GridRestResponse>();
        GridRestResponse res = new GridRestResponse();
        try {
            switch (req.command()) {
                case CLUSTER_CURRENT_STATE: {
                    Boolean currentState = this.ctx.state().publicApiActiveState(false);
                    res.setResponse(currentState);
                    break;
                }
                case CLUSTER_ACTIVE: 
                case CLUSTER_INACTIVE: {
                    this.log.warning(req.command().key() + " is deprecated. Use newer commands.");
                }
                default: {
                    this.ctx.grid().cluster().active(req.active());
                    res.setResponse(req.command().key() + " started");
                }
            }
            fut.onDone(res);
        }
        catch (Exception e) {
            res.setError(GridChangeStateCommandHandler.errorMessage(e));
            fut.onDone(res);
        }
        return fut;
    }
}

