/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.BinaryConfiguration;
import org.apache.ignite.configuration.ClientConnectorConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.HadoopConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.node.VisorAtomicConfiguration;
import org.apache.ignite.internal.visor.node.VisorBasicConfiguration;
import org.apache.ignite.internal.visor.node.VisorBinaryConfiguration;
import org.apache.ignite.internal.visor.node.VisorCacheKeyConfiguration;
import org.apache.ignite.internal.visor.node.VisorClientConnectorConfiguration;
import org.apache.ignite.internal.visor.node.VisorDataStorageConfiguration;
import org.apache.ignite.internal.visor.node.VisorExecutorServiceConfiguration;
import org.apache.ignite.internal.visor.node.VisorHadoopConfiguration;
import org.apache.ignite.internal.visor.node.VisorIgfsConfiguration;
import org.apache.ignite.internal.visor.node.VisorLifecycleConfiguration;
import org.apache.ignite.internal.visor.node.VisorMemoryConfiguration;
import org.apache.ignite.internal.visor.node.VisorMetricsConfiguration;
import org.apache.ignite.internal.visor.node.VisorMvccConfiguration;
import org.apache.ignite.internal.visor.node.VisorPeerToPeerConfiguration;
import org.apache.ignite.internal.visor.node.VisorPersistentStoreConfiguration;
import org.apache.ignite.internal.visor.node.VisorRestConfiguration;
import org.apache.ignite.internal.visor.node.VisorSegmentationConfiguration;
import org.apache.ignite.internal.visor.node.VisorServiceConfiguration;
import org.apache.ignite.internal.visor.node.VisorSpisConfiguration;
import org.apache.ignite.internal.visor.node.VisorSqlConnectorConfiguration;
import org.apache.ignite.internal.visor.node.VisorTransactionConfiguration;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;

public class VisorGridConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private VisorBasicConfiguration basic;
    private VisorMetricsConfiguration metrics;
    private VisorSpisConfiguration spis;
    private VisorPeerToPeerConfiguration p2p;
    private VisorLifecycleConfiguration lifecycle;
    private VisorExecutorServiceConfiguration execSvc;
    private VisorSegmentationConfiguration seg;
    private String inclProps;
    private int[] inclEvtTypes;
    private VisorRestConfiguration rest;
    private Map<String, ?> userAttrs;
    private List<VisorIgfsConfiguration> igfss;
    private Map<String, String> env;
    private Properties sysProps;
    private VisorAtomicConfiguration atomic;
    private VisorTransactionConfiguration txCfg;
    private VisorMemoryConfiguration memCfg;
    private VisorPersistentStoreConfiguration psCfg;
    private String storeSesLsnrs;
    private String warmupClos;
    private VisorBinaryConfiguration binaryCfg;
    private List<VisorCacheKeyConfiguration> cacheKeyCfgs;
    private VisorHadoopConfiguration hadoopCfg;
    private VisorSqlConnectorConfiguration sqlConnCfg;
    private List<VisorServiceConfiguration> srvcCfgs;
    private VisorDataStorageConfiguration dataStorage;
    private VisorClientConnectorConfiguration clnConnCfg;
    private VisorMvccConfiguration mvccCfg;

    public VisorGridConfiguration() {
    }

    public VisorGridConfiguration(IgniteEx ignite) {
        ClientConnectorConfiguration ccc;
        assert (ignite != null);
        IgniteConfiguration c = ignite.configuration();
        this.basic = new VisorBasicConfiguration(ignite, c);
        this.metrics = new VisorMetricsConfiguration(c);
        this.spis = new VisorSpisConfiguration(c);
        this.p2p = new VisorPeerToPeerConfiguration(c);
        this.lifecycle = new VisorLifecycleConfiguration(c);
        this.execSvc = new VisorExecutorServiceConfiguration(c);
        this.seg = new VisorSegmentationConfiguration(c);
        this.inclProps = VisorTaskUtils.compactArray(c.getIncludeProperties());
        this.inclEvtTypes = c.getIncludeEventTypes();
        this.rest = new VisorRestConfiguration(c);
        this.userAttrs = c.getUserAttributes();
        this.igfss = VisorIgfsConfiguration.list(c.getFileSystemConfiguration());
        this.env = new HashMap<String, String>(System.getenv());
        this.sysProps = IgniteSystemProperties.snapshot();
        this.atomic = new VisorAtomicConfiguration(c.getAtomicConfiguration());
        this.txCfg = new VisorTransactionConfiguration(c.getTransactionConfiguration());
        if (c.getDataStorageConfiguration() != null) {
            this.memCfg = null;
        }
        if (c.getDataStorageConfiguration() != null) {
            this.psCfg = null;
        }
        this.storeSesLsnrs = VisorTaskUtils.compactArray(c.getCacheStoreSessionListenerFactories());
        this.warmupClos = VisorTaskUtils.compactClass(c.getWarmupClosure());
        BinaryConfiguration bc = c.getBinaryConfiguration();
        if (bc != null) {
            this.binaryCfg = new VisorBinaryConfiguration(bc);
        }
        this.cacheKeyCfgs = VisorCacheKeyConfiguration.list(c.getCacheKeyConfiguration());
        HadoopConfiguration hc = c.getHadoopConfiguration();
        if (hc != null) {
            this.hadoopCfg = new VisorHadoopConfiguration(hc);
        }
        if ((ccc = c.getClientConnectorConfiguration()) != null) {
            this.clnConnCfg = new VisorClientConnectorConfiguration(ccc);
        }
        this.srvcCfgs = VisorServiceConfiguration.list(c.getServiceConfiguration());
        DataStorageConfiguration dsCfg = c.getDataStorageConfiguration();
        if (dsCfg != null) {
            this.dataStorage = new VisorDataStorageConfiguration(dsCfg);
        }
        this.mvccCfg = new VisorMvccConfiguration(c);
    }

    public VisorBasicConfiguration getBasic() {
        return this.basic;
    }

    public VisorMetricsConfiguration getMetrics() {
        return this.metrics;
    }

    public VisorSpisConfiguration getSpis() {
        return this.spis;
    }

    public VisorPeerToPeerConfiguration getP2p() {
        return this.p2p;
    }

    public VisorLifecycleConfiguration getLifecycle() {
        return this.lifecycle;
    }

    public VisorExecutorServiceConfiguration getExecutorService() {
        return this.execSvc;
    }

    public VisorSegmentationConfiguration getSegmentation() {
        return this.seg;
    }

    public String getIncludeProperties() {
        return this.inclProps;
    }

    public int[] getIncludeEventTypes() {
        return this.inclEvtTypes;
    }

    public VisorRestConfiguration getRest() {
        return this.rest;
    }

    public Map<String, ?> getUserAttributes() {
        return this.userAttrs;
    }

    public List<VisorIgfsConfiguration> getIgfss() {
        return this.igfss;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public Properties getSystemProperties() {
        return this.sysProps;
    }

    public VisorAtomicConfiguration getAtomic() {
        return this.atomic;
    }

    public VisorTransactionConfiguration getTransaction() {
        return this.txCfg;
    }

    public VisorMemoryConfiguration getMemoryConfiguration() {
        return this.memCfg;
    }

    public VisorPersistentStoreConfiguration getPersistentStoreConfiguration() {
        return this.psCfg;
    }

    public String getCacheStoreSessionListenerFactories() {
        return this.storeSesLsnrs;
    }

    public String getWarmupClosure() {
        return this.warmupClos;
    }

    public VisorBinaryConfiguration getBinaryConfiguration() {
        return this.binaryCfg;
    }

    public List<VisorCacheKeyConfiguration> getCacheKeyConfigurations() {
        return this.cacheKeyCfgs;
    }

    public VisorHadoopConfiguration getHadoopConfiguration() {
        return this.hadoopCfg;
    }

    public VisorSqlConnectorConfiguration getSqlConnectorConfiguration() {
        return this.sqlConnCfg;
    }

    public VisorClientConnectorConfiguration getClientConnectorConfiguration() {
        return this.clnConnCfg;
    }

    public List<VisorServiceConfiguration> getServiceConfigurations() {
        return this.srvcCfgs;
    }

    public VisorDataStorageConfiguration getDataStorageConfiguration() {
        return this.dataStorage;
    }

    public VisorMvccConfiguration getMvccConfiguration() {
        return this.mvccCfg;
    }

    @Override
    public byte getProtocolVersion() {
        return 4;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeObject(this.basic);
        out.writeObject(this.metrics);
        out.writeObject(this.spis);
        out.writeObject(this.p2p);
        out.writeObject(this.lifecycle);
        out.writeObject(this.execSvc);
        out.writeObject(this.seg);
        U.writeString(out, this.inclProps);
        out.writeObject(this.inclEvtTypes);
        out.writeObject(this.rest);
        U.writeMap(out, this.userAttrs);
        U.writeCollection(out, this.igfss);
        U.writeMap(out, this.env);
        out.writeObject(this.sysProps);
        out.writeObject(this.atomic);
        out.writeObject(this.txCfg);
        out.writeObject(this.memCfg);
        out.writeObject(this.psCfg);
        U.writeString(out, this.storeSesLsnrs);
        U.writeString(out, this.warmupClos);
        out.writeObject(this.binaryCfg);
        U.writeCollection(out, this.cacheKeyCfgs);
        out.writeObject(this.hadoopCfg);
        out.writeObject(this.sqlConnCfg);
        U.writeCollection(out, this.srvcCfgs);
        out.writeObject(this.dataStorage);
        out.writeObject(this.clnConnCfg);
        out.writeObject(this.mvccCfg);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.basic = (VisorBasicConfiguration)in.readObject();
        this.metrics = (VisorMetricsConfiguration)in.readObject();
        this.spis = (VisorSpisConfiguration)in.readObject();
        this.p2p = (VisorPeerToPeerConfiguration)in.readObject();
        this.lifecycle = (VisorLifecycleConfiguration)in.readObject();
        this.execSvc = (VisorExecutorServiceConfiguration)in.readObject();
        this.seg = (VisorSegmentationConfiguration)in.readObject();
        this.inclProps = U.readString(in);
        this.inclEvtTypes = (int[])in.readObject();
        this.rest = (VisorRestConfiguration)in.readObject();
        this.userAttrs = U.readMap(in);
        this.igfss = U.readList(in);
        this.env = U.readMap(in);
        this.sysProps = (Properties)in.readObject();
        this.atomic = (VisorAtomicConfiguration)in.readObject();
        this.txCfg = (VisorTransactionConfiguration)in.readObject();
        this.memCfg = (VisorMemoryConfiguration)in.readObject();
        this.psCfg = (VisorPersistentStoreConfiguration)in.readObject();
        this.storeSesLsnrs = U.readString(in);
        this.warmupClos = U.readString(in);
        this.binaryCfg = (VisorBinaryConfiguration)in.readObject();
        this.cacheKeyCfgs = U.readList(in);
        this.hadoopCfg = (VisorHadoopConfiguration)in.readObject();
        this.sqlConnCfg = (VisorSqlConnectorConfiguration)in.readObject();
        this.srvcCfgs = U.readList(in);
        if (protoVer > 1) {
            this.dataStorage = (VisorDataStorageConfiguration)in.readObject();
        }
        if (protoVer > 2) {
            this.clnConnCfg = (VisorClientConnectorConfiguration)in.readObject();
        }
        if (protoVer > 3) {
            this.mvccCfg = (VisorMvccConfiguration)in.readObject();
        }
    }

    public String toString() {
        return S.toString(VisorGridConfiguration.class, this);
    }
}

