/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.verify;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.ignite.internal.processors.cache.verify.PartitionKey;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.verify.IndexIntegrityCheckIssue;
import org.apache.ignite.internal.visor.verify.ValidateIndexesPartitionResult;
import org.jetbrains.annotations.NotNull;

public class VisorValidateIndexesJobResult
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private Map<PartitionKey, ValidateIndexesPartitionResult> partRes;
    @GridToStringInclude
    private Map<String, ValidateIndexesPartitionResult> idxRes;
    @GridToStringInclude
    private Collection<IndexIntegrityCheckIssue> integrityCheckFailures;

    public VisorValidateIndexesJobResult(@NotNull Map<PartitionKey, ValidateIndexesPartitionResult> partRes, @NotNull Map<String, ValidateIndexesPartitionResult> idxRes, @NotNull Collection<IndexIntegrityCheckIssue> integrityCheckFailures) {
        this.partRes = partRes;
        this.idxRes = idxRes;
        this.integrityCheckFailures = integrityCheckFailures;
    }

    public VisorValidateIndexesJobResult() {
    }

    @Override
    public byte getProtocolVersion() {
        return 3;
    }

    public Map<PartitionKey, ValidateIndexesPartitionResult> partitionResult() {
        return this.partRes;
    }

    public Map<String, ValidateIndexesPartitionResult> indexResult() {
        return this.idxRes == null ? Collections.emptyMap() : this.idxRes;
    }

    public Collection<IndexIntegrityCheckIssue> integrityCheckFailures() {
        return this.integrityCheckFailures == null ? Collections.emptyList() : this.integrityCheckFailures;
    }

    public boolean hasIssues() {
        return this.integrityCheckFailures != null && !this.integrityCheckFailures.isEmpty() || this.partRes != null && this.partRes.entrySet().stream().anyMatch(e -> !((ValidateIndexesPartitionResult)e.getValue()).issues().isEmpty()) || this.idxRes != null && this.idxRes.entrySet().stream().anyMatch(e -> !((ValidateIndexesPartitionResult)e.getValue()).issues().isEmpty());
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeMap(out, this.partRes);
        U.writeMap(out, this.idxRes);
        U.writeCollection(out, this.integrityCheckFailures);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.partRes = U.readMap(in);
        if (protoVer >= 2) {
            this.idxRes = U.readMap(in);
        }
        if (protoVer >= 3) {
            this.integrityCheckFailures = U.readCollection(in);
        }
    }

    public String toString() {
        return S.toString(VisorValidateIndexesJobResult.class, this);
    }
}

