/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.mxbean;

import org.apache.ignite.DataStorageMetrics;
import org.apache.ignite.mxbean.MXBeanDescription;
import org.apache.ignite.mxbean.MXBeanParametersDescriptions;
import org.apache.ignite.mxbean.MXBeanParametersNames;

public interface DataStorageMetricsMXBean
extends DataStorageMetrics {
    @Override
    @MXBeanDescription(value="Average number of WAL records per second written during the last time interval.")
    public float getWalLoggingRate();

    @Override
    @MXBeanDescription(value="Average number of bytes per second written during the last time interval.")
    public float getWalWritingRate();

    @Override
    @MXBeanDescription(value="Current number of WAL segments in the WAL archive.")
    public int getWalArchiveSegments();

    @Override
    @MXBeanDescription(value="Average WAL fsync duration in microseconds over the last time interval.")
    public float getWalFsyncTimeAverage();

    @Override
    @MXBeanDescription(value="WAL buffer poll spins number over the last time interval.")
    public long getWalBuffPollSpinsRate();

    @Override
    @MXBeanDescription(value="Total size in bytes for storage wal files.")
    public long getWalTotalSize();

    @Override
    @MXBeanDescription(value="Time of the last WAL segment rollover.")
    public long getWalLastRollOverTime();

    @Override
    @MXBeanDescription(value="Total checkpoint time from last restart.")
    public long getCheckpointTotalTime();

    @Override
    @MXBeanDescription(value="Used checkpoint buffer size in pages.")
    public long getUsedCheckpointBufferPages();

    @Override
    @MXBeanDescription(value="Used checkpoint buffer size in bytes.")
    public long getUsedCheckpointBufferSize();

    @Override
    @MXBeanDescription(value="Total size in bytes for checkpoint buffer.")
    public long getCheckpointBufferSize();

    @Override
    @MXBeanDescription(value="Duration of the last checkpoint in milliseconds.")
    public long getLastCheckpointDuration();

    @Override
    @MXBeanDescription(value="Duration of the checkpoint lock wait in milliseconds.")
    public long getLastCheckpointLockWaitDuration();

    @Override
    @MXBeanDescription(value="Duration of the checkpoint mark in milliseconds.")
    public long getLastCheckpointMarkDuration();

    @Override
    @MXBeanDescription(value="Duration of the checkpoint pages write in milliseconds.")
    public long getLastCheckpointPagesWriteDuration();

    @Override
    @MXBeanDescription(value="Duration of the sync phase of the last checkpoint in milliseconds.")
    public long getLastCheckpointFsyncDuration();

    @Override
    @MXBeanDescription(value="Total number of pages written during the last checkpoint.")
    public long getLastCheckpointTotalPagesNumber();

    @Override
    @MXBeanDescription(value="Total number of data pages written during the last checkpoint.")
    public long getLastCheckpointDataPagesNumber();

    @Override
    @MXBeanDescription(value="Number of pages copied to a temporary checkpoint buffer during the last checkpoint.")
    public long getLastCheckpointCopiedOnWritePagesNumber();

    @Override
    @MXBeanDescription(value="Total dirty pages for the next checkpoint.")
    public long getDirtyPages();

    @Override
    @MXBeanDescription(value="The number of read pages from last restart.")
    public long getPagesRead();

    @Override
    @MXBeanDescription(value="The number of written pages from last restart.")
    public long getPagesWritten();

    @Override
    @MXBeanDescription(value="The number of replaced pages from last restart.")
    public long getPagesReplaced();

    @Override
    @MXBeanDescription(value="Total offheap size in bytes.")
    public long getOffHeapSize();

    @Override
    @MXBeanDescription(value="Total used offheap size in bytes.")
    public long getOffheapUsedSize();

    @Override
    @MXBeanDescription(value="Total size of memory allocated in bytes.")
    public long getTotalAllocatedSize();

    @MXBeanDescription(value="Enables persistence metrics collection on an Apache Ignite node.")
    public void enableMetrics();

    @MXBeanDescription(value="Disables persistence metrics collection on an Apache Ignite node.")
    public void disableMetrics();

    @MXBeanDescription(value="Sets time interval for pages allocation and eviction monitoring purposes.")
    @MXBeanParametersNames(value={"rateTimeInterval"})
    @MXBeanParametersDescriptions(value={"Time interval (in milliseconds) to set."})
    @Deprecated
    public void rateTimeInterval(long var1);

    @MXBeanDescription(value="Sets a number of sub-intervals to calculate allocation and eviction rates metrics.")
    @MXBeanParametersNames(value={"subInts"})
    @MXBeanParametersDescriptions(value={"Number of subintervals to set."})
    @Deprecated
    public void subIntervals(int var1);

    @Override
    @MXBeanDescription(value="Storage space allocated, in bytes.")
    public long getStorageSize();

    @Override
    @MXBeanDescription(value="Storage space allocated adjusted for possible sparsity, in bytes.")
    public long getSparseStorageSize();
}

