/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.managers.communication.IgniteMessageFactoryImpl;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.util.collection.IntHashMap;
import org.apache.ignite.internal.util.collection.IntMap;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.plugin.extensions.communication.IgniteMessageFactory;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.IgniteSpiContext;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.metric.LongMetric;
import org.apache.ignite.spi.metric.Metric;
import org.apache.ignite.spi.metric.ReadOnlyMetricRegistry;

class TcpCommunicationMetricsListener {
    private final IgniteSpiContext spiCtx;
    private final MetricRegistry mreg;
    private final Ignite ignite;
    private final Set<ThreadMetrics> allMetrics = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ThreadLocal<ThreadMetrics> threadMetrics = ThreadLocal.withInitial(() -> {
        ThreadMetrics metrics = new ThreadMetrics();
        this.allMetrics.add(metrics);
        return metrics;
    });
    private final Function<Object, LongAdderMetric> sentMsgsCntByConsistentIdMetricFactory;
    private final Function<Object, LongAdderMetric> rcvdMsgsCntByConsistentIdMetricFactory;
    private final LongAdderMetric sentBytesMetric;
    private final LongAdderMetric rcvdBytesMetric;
    private final LongAdderMetric sentMsgsMetric;
    private final LongAdderMetric rcvdMsgsMetric;
    private final IntMap<IgniteBiTuple<LongAdderMetric, LongAdderMetric>> msgCntrsByType;
    private final Object msgTypeMapMux = new Object();
    private volatile Map<Short, String> msgTypeMap;

    public TcpCommunicationMetricsListener(Ignite ignite, IgniteSpiContext spiCtx) {
        this.ignite = ignite;
        this.spiCtx = spiCtx;
        this.mreg = (MetricRegistry)spiCtx.getOrCreateMetricRegistry(TcpCommunicationSpi.COMMUNICATION_METRICS_GROUP_NAME);
        this.msgCntrsByType = this.createMessageCounters((IgniteMessageFactory)spiCtx.messageFactory());
        this.sentMsgsCntByConsistentIdMetricFactory = consistentId -> {
            String name = MetricUtils.metricName(TcpCommunicationSpi.COMMUNICATION_METRICS_GROUP_NAME, consistentId.toString());
            return (LongAdderMetric)spiCtx.getOrCreateMetricRegistry(name).findMetric("sentMessagesToNode");
        };
        this.rcvdMsgsCntByConsistentIdMetricFactory = consistentId -> {
            String name = MetricUtils.metricName(TcpCommunicationSpi.COMMUNICATION_METRICS_GROUP_NAME, consistentId.toString());
            return (LongAdderMetric)spiCtx.getOrCreateMetricRegistry(name).findMetric("receivedMessagesFromNode");
        };
        this.sentBytesMetric = this.mreg.longAdderMetric("sentBytes", "Total number of bytes sent by current node");
        this.rcvdBytesMetric = this.mreg.longAdderMetric("receivedBytes", "Total number of bytes received by current node");
        this.sentMsgsMetric = this.mreg.longAdderMetric("sentMessagesCount", "Total number of messages sent by current node");
        this.rcvdMsgsMetric = this.mreg.longAdderMetric("receivedMessagesCount", "Total number of messages received by current node");
        spiCtx.addMetricRegistryCreationListener(mreg -> {
            if (!mreg.name().startsWith(TcpCommunicationSpi.COMMUNICATION_METRICS_GROUP_NAME + ".")) {
                return;
            }
            ((MetricRegistry)mreg).longAdderMetric("sentMessagesToNode", "Total number of messages sent by current node to the given node");
            ((MetricRegistry)mreg).longAdderMetric("receivedMessagesFromNode", "Total number of messages received by current node from the given node");
        });
    }

    private IntMap<IgniteBiTuple<LongAdderMetric, LongAdderMetric>> createMessageCounters(IgniteMessageFactory factory) {
        IgniteMessageFactoryImpl msgFactory = (IgniteMessageFactoryImpl)factory;
        short[] directTypes = msgFactory.registeredDirectTypes();
        IntHashMap<IgniteBiTuple<LongAdderMetric, LongAdderMetric>> msgCntrsByType = new IntHashMap<IgniteBiTuple<LongAdderMetric, LongAdderMetric>>(directTypes.length);
        for (short type : directTypes) {
            LongAdderMetric sentCnt = this.mreg.longAdderMetric(TcpCommunicationMetricsListener.sentMessagesByTypeMetricName(type), "Total number of messages with given type sent by current node");
            LongAdderMetric rcvCnt = this.mreg.longAdderMetric(TcpCommunicationMetricsListener.receivedMessagesByTypeMetricName(type), "Total number of messages with given type received by current node");
            msgCntrsByType.put(type, new IgniteBiTuple<LongAdderMetric, LongAdderMetric>(sentCnt, rcvCnt));
        }
        return msgCntrsByType;
    }

    public MetricRegistry metricRegistry() {
        return this.mreg;
    }

    public void onMessageSent(Message msg, Object consistentId) {
        assert (msg != null);
        assert (consistentId != null);
        if (msg instanceof GridIoMessage) {
            msg = ((GridIoMessage)msg).message();
            this.updateMessageTypeMap(msg);
            this.sentMsgsMetric.increment();
            this.threadMetrics.get().onMessageSent(msg, consistentId);
        }
    }

    public void onMessageReceived(Message msg, Object consistentId) {
        assert (msg != null);
        assert (consistentId != null);
        if (msg instanceof GridIoMessage) {
            msg = ((GridIoMessage)msg).message();
            this.updateMessageTypeMap(msg);
            this.rcvdMsgsMetric.increment();
            this.threadMetrics.get().onMessageReceived(msg, consistentId);
        }
    }

    public int sentMessagesCount() {
        int res0 = (int)this.sentMsgsMetric.value();
        return res0 < 0 ? Integer.MAX_VALUE : res0;
    }

    public long sentBytesCount() {
        return this.sentBytesMetric.value();
    }

    public int receivedMessagesCount() {
        int res0 = (int)this.rcvdMsgsMetric.value();
        return res0 < 0 ? Integer.MAX_VALUE : res0;
    }

    public long receivedBytesCount() {
        return this.rcvdBytesMetric.value();
    }

    public Map<String, Long> receivedMessagesByType() {
        return this.collectMessagesCountByType("receivedMessagesByType.");
    }

    public Map<UUID, Long> receivedMessagesByNode() {
        return this.collectMessagesCountByNodeId("receivedMessagesFromNode");
    }

    public Map<String, Long> sentMessagesByType() {
        return this.collectMessagesCountByType("sentMessagesByType.");
    }

    public Map<UUID, Long> sentMessagesByNode() {
        return this.collectMessagesCountByNodeId("sentMessagesToNode");
    }

    protected Map<String, Long> collectMessagesCountByType(String prefix) {
        HashMap<String, Long> res = new HashMap<String, Long>();
        prefix = MetricUtils.metricName(TcpCommunicationSpi.COMMUNICATION_METRICS_GROUP_NAME, prefix);
        for (Metric metric : this.mreg) {
            String typeName;
            if (!metric.name().startsWith(prefix)) continue;
            short directType = Short.parseShort(metric.name().substring(prefix.length()));
            Map<Short, String> msgTypeMap0 = this.msgTypeMap;
            if (msgTypeMap0 == null || (typeName = msgTypeMap0.get(directType)) == null) continue;
            res.put(typeName, ((LongMetric)metric).value());
        }
        return res;
    }

    protected Map<UUID, Long> collectMessagesCountByNodeId(String metricName) {
        HashMap<UUID, Long> res = new HashMap<UUID, Long>();
        Map<String, UUID> nodesMapping = this.ignite.cluster().nodes().stream().collect(Collectors.toMap(node -> node.consistentId().toString(), ClusterNode::id));
        String mregPrefix = TcpCommunicationSpi.COMMUNICATION_METRICS_GROUP_NAME + ".";
        for (ReadOnlyMetricRegistry mreg : this.spiCtx.metricRegistries()) {
            String nodeConsIdStr;
            UUID nodeId;
            if (!mreg.name().startsWith(mregPrefix) || (nodeId = nodesMapping.get(nodeConsIdStr = mreg.name().substring(mregPrefix.length()))) == null) continue;
            res.put(nodeId, ((LongMetric)mreg.findMetric(metricName)).value());
        }
        return res;
    }

    public void resetMetrics() {
        this.rcvdMsgsMetric.reset();
        this.sentMsgsMetric.reset();
        this.sentBytesMetric.reset();
        this.rcvdBytesMetric.reset();
        for (Metric metric : this.mreg) {
            if (metric.name().startsWith("sentMessagesByType")) {
                metric.reset();
                continue;
            }
            if (!metric.name().startsWith("receivedMessagesByType")) continue;
            metric.reset();
        }
        for (ReadOnlyMetricRegistry mreg : this.spiCtx.metricRegistries()) {
            if (!mreg.name().startsWith(TcpCommunicationSpi.COMMUNICATION_METRICS_GROUP_NAME + ".")) continue;
            mreg.findMetric("sentMessagesToNode").reset();
            mreg.findMetric("receivedMessagesFromNode").reset();
        }
    }

    public void onNodeLeft(Object consistentId) {
        for (ThreadMetrics threadMetrics : this.allMetrics) {
            threadMetrics.sentMsgsMetricsByConsistentId = new HashMap<Object, LongAdderMetric>();
            threadMetrics.rcvdMsgsMetricsByConsistentId = new HashMap<Object, LongAdderMetric>();
        }
        this.spiCtx.removeMetricRegistry(MetricUtils.metricName(TcpCommunicationSpi.COMMUNICATION_METRICS_GROUP_NAME, consistentId.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMessageTypeMap(Message msg) {
        short typeId = msg.directType();
        Map<Short, String> msgTypeMap0 = this.msgTypeMap;
        if (msgTypeMap0 == null || !msgTypeMap0.containsKey(typeId)) {
            Object object = this.msgTypeMapMux;
            synchronized (object) {
                if (this.msgTypeMap == null) {
                    msgTypeMap0 = new HashMap<Short, String>();
                    msgTypeMap0.put(typeId, msg.getClass().getName());
                    this.msgTypeMap = msgTypeMap0;
                } else if (!this.msgTypeMap.containsKey(typeId)) {
                    msgTypeMap0 = new HashMap<Short, String>(this.msgTypeMap);
                    msgTypeMap0.put(typeId, msg.getClass().getName());
                    this.msgTypeMap = msgTypeMap0;
                }
            }
        }
    }

    public static String sentMessagesByTypeMetricName(Short directType) {
        return MetricUtils.metricName("sentMessagesByType", directType.toString());
    }

    public static String receivedMessagesByTypeMetricName(Short directType) {
        return MetricUtils.metricName("receivedMessagesByType", directType.toString());
    }

    private class ThreadMetrics {
        volatile Map<Object, LongAdderMetric> sentMsgsMetricsByConsistentId = new HashMap<Object, LongAdderMetric>();
        volatile Map<Object, LongAdderMetric> rcvdMsgsMetricsByConsistentId = new HashMap<Object, LongAdderMetric>();

        private ThreadMetrics() {
        }

        private void onMessageSent(Message msg, Object consistentId) {
            IgniteBiTuple cnts = (IgniteBiTuple)TcpCommunicationMetricsListener.this.msgCntrsByType.get(msg.directType());
            ((LongAdderMetric)cnts.get1()).increment();
            this.sentMsgsMetricsByConsistentId.computeIfAbsent(consistentId, TcpCommunicationMetricsListener.this.sentMsgsCntByConsistentIdMetricFactory).increment();
        }

        private void onMessageReceived(Message msg, Object consistentId) {
            IgniteBiTuple cnts = (IgniteBiTuple)TcpCommunicationMetricsListener.this.msgCntrsByType.get(msg.directType());
            ((LongAdderMetric)cnts.get2()).increment();
            this.rcvdMsgsMetricsByConsistentId.computeIfAbsent(consistentId, TcpCommunicationMetricsListener.this.rcvdMsgsCntByConsistentIdMetricFactory).increment();
        }
    }
}

