/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.InconsistentFSStateException;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NNUpgradeUtil;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.tools.DFSHAAdmin;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public class BootstrapStandby
implements Tool,
Configurable {
    private static final Log LOG = LogFactory.getLog(BootstrapStandby.class);
    private String nsId;
    private String nnId;
    private String otherNNId;
    private URL otherHttpAddr;
    private InetSocketAddress otherIpcAddr;
    private Collection<URI> dirsToFormat;
    private List<URI> editUrisToFormat;
    private List<URI> sharedEditsUris;
    private Configuration conf;
    private boolean force = false;
    private boolean interactive = true;
    private boolean skipSharedEditsCheck = false;
    static final int ERR_CODE_FAILED_CONNECT = 2;
    static final int ERR_CODE_INVALID_VERSION = 3;
    static final int ERR_CODE_ALREADY_FORMATTED = 5;
    static final int ERR_CODE_LOGS_UNAVAILABLE = 6;

    public int run(String[] args) throws Exception {
        this.parseArgs(args);
        this.parseConfAndFindOtherNN();
        NameNode.checkAllowFormat(this.conf);
        InetSocketAddress myAddr = DFSUtilClient.getNNAddress((Configuration)this.conf);
        SecurityUtil.login((Configuration)this.conf, (String)"dfs.namenode.keytab.file", (String)"dfs.namenode.kerberos.principal", (String)myAddr.getHostName());
        return (Integer)SecurityUtil.doAsLoginUserOrFatal((PrivilegedAction)new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                try {
                    return BootstrapStandby.this.doRun();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void parseArgs(String[] args) {
        for (String arg : args) {
            if ("-force".equals(arg)) {
                this.force = true;
                continue;
            }
            if ("-nonInteractive".equals(arg)) {
                this.interactive = false;
                continue;
            }
            if ("-skipSharedEditsCheck".equals(arg)) {
                this.skipSharedEditsCheck = true;
                continue;
            }
            this.printUsage();
            throw new HadoopIllegalArgumentException("Illegal argument: " + arg);
        }
    }

    private void printUsage() {
        System.out.println("Usage: " + this.getClass().getSimpleName() + " [-force] [-nonInteractive] [-skipSharedEditsCheck]\n" + "\t-force: formats if the name directory exists.\n" + "\t-nonInteractive: formats aborts if the name directory exists,\n" + "\tunless -force option is specified.\n" + "\t-skipSharedEditsCheck: skips edits check which ensures that\n" + "\twe have enough edits already in the shared directory to start\n" + "\tup from the last checkpoint on the active.");
    }

    private NamenodeProtocol createNNProtocolProxy() throws IOException {
        return (NamenodeProtocol)NameNodeProxies.createNonHAProxy(this.getConf(), this.otherIpcAddr, NamenodeProtocol.class, UserGroupInformation.getLoginUser(), true).getProxy();
    }

    private int doRun() throws IOException {
        int download;
        boolean isUpgradeFinalized;
        NamespaceInfo nsInfo;
        NamenodeProtocol proxy = this.createNNProtocolProxy();
        try {
            nsInfo = proxy.versionRequest();
            isUpgradeFinalized = proxy.isUpgradeFinalized();
        }
        catch (IOException ioe) {
            LOG.fatal((Object)("Unable to fetch namespace information from active NN at " + this.otherIpcAddr + ": " + ioe.getMessage()));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Full exception trace", (Throwable)ioe);
            }
            return 2;
        }
        if (!this.checkLayoutVersion(nsInfo)) {
            LOG.fatal((Object)("Layout version on remote node (" + nsInfo.getLayoutVersion() + ") does not match " + "this node's layout version (" + HdfsServerConstants.NAMENODE_LAYOUT_VERSION + ")"));
            return 3;
        }
        System.out.println("=====================================================\nAbout to bootstrap Standby ID " + this.nnId + " from:\n" + "           Nameservice ID: " + this.nsId + "\n" + "        Other Namenode ID: " + this.otherNNId + "\n" + "  Other NN's HTTP address: " + this.otherHttpAddr + "\n" + "  Other NN's IPC  address: " + this.otherIpcAddr + "\n" + "             Namespace ID: " + nsInfo.getNamespaceID() + "\n" + "            Block pool ID: " + nsInfo.getBlockPoolID() + "\n" + "               Cluster ID: " + nsInfo.getClusterID() + "\n" + "           Layout version: " + nsInfo.getLayoutVersion() + "\n" + "       isUpgradeFinalized: " + isUpgradeFinalized + "\n" + "=====================================================");
        NNStorage storage = new NNStorage(this.conf, this.dirsToFormat, this.editUrisToFormat);
        if (!isUpgradeFinalized) {
            LOG.info((Object)"The active NameNode is in Upgrade. Prepare the upgrade for the standby NameNode as well.");
            if (!this.doPreUpgrade(storage, nsInfo)) {
                return 5;
            }
        } else if (!this.format(storage, nsInfo)) {
            return 5;
        }
        if ((download = this.downloadImage(storage, proxy)) != 0) {
            return download;
        }
        if (!isUpgradeFinalized) {
            this.doUpgrade(storage);
        }
        return 0;
    }

    private boolean format(NNStorage storage, NamespaceInfo nsInfo) throws IOException {
        if (!Storage.confirmFormat(storage.dirIterable(null), this.force, this.interactive)) {
            storage.close();
            return false;
        }
        storage.format(nsInfo);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doPreUpgrade(NNStorage storage, NamespaceInfo nsInfo) throws IOException {
        boolean isFormatted = false;
        HashMap<Storage.StorageDirectory, Storage.StorageState> dataDirStates = new HashMap<Storage.StorageDirectory, Storage.StorageState>();
        try {
            isFormatted = FSImage.recoverStorageDirs(HdfsServerConstants.StartupOption.UPGRADE, storage, dataDirStates);
            if (dataDirStates.values().contains((Object)Storage.StorageState.NOT_FORMATTED)) {
                isFormatted = false;
                System.err.println("The original storage directory is not formatted.");
            }
        }
        catch (InconsistentFSStateException e) {
            LOG.warn((Object)"The storage directory is in an inconsistent state", (Throwable)e);
        }
        finally {
            storage.unlockAll();
        }
        if (!isFormatted && !this.format(storage, nsInfo)) {
            return false;
        }
        FSImage.checkUpgrade(storage);
        Iterator<Storage.StorageDirectory> it = storage.dirIterator(false);
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            try {
                NNUpgradeUtil.renameCurToTmp(sd);
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to move aside pre-upgrade storage in image directory " + sd.getRoot()), (Throwable)e);
                throw e;
            }
        }
        storage.setStorageInfo(nsInfo);
        storage.setBlockPoolID(nsInfo.getBlockPoolID());
        return true;
    }

    private void doUpgrade(NNStorage storage) throws IOException {
        Iterator<Storage.StorageDirectory> it = storage.dirIterator(false);
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            NNUpgradeUtil.doUpgrade(sd, storage);
        }
    }

    private int downloadImage(NNStorage storage, NamenodeProtocol proxy) throws IOException {
        long imageTxId = proxy.getMostRecentCheckpointTxId();
        long curTxId = proxy.getTransactionID();
        try (FSImage image = new FSImage(this.conf);){
            image.getStorage().setStorageInfo(storage);
            image.initEditLog(HdfsServerConstants.StartupOption.REGULAR);
            assert (image.getEditLog().isOpenForRead()) : "Expected edit log to be open for read";
            if (!this.skipSharedEditsCheck && !this.checkLogsAvailableForRead(image, imageTxId, curTxId)) {
                int n = 6;
                return n;
            }
            MD5Hash hash = TransferFsImage.downloadImageToStorage(this.otherHttpAddr, imageTxId, storage, true, true);
            image.saveDigestAndRenameCheckpointImage(NNStorage.NameNodeFile.IMAGE, imageTxId, hash);
            storage.writeTransactionIdFileToStorage(imageTxId, NNStorage.NameNodeDirType.IMAGE);
        }
        return 0;
    }

    private boolean checkLogsAvailableForRead(FSImage image, long imageTxId, long curTxIdOnOtherNode) {
        if (imageTxId == curTxIdOnOtherNode) {
            return true;
        }
        long firstTxIdInLogs = imageTxId + 1L;
        assert (curTxIdOnOtherNode >= firstTxIdInLogs) : "first=" + firstTxIdInLogs + " onOtherNode=" + curTxIdOnOtherNode;
        try {
            Collection<EditLogInputStream> streams = image.getEditLog().selectInputStreams(firstTxIdInLogs, curTxIdOnOtherNode, null, true);
            for (EditLogInputStream stream : streams) {
                IOUtils.closeStream((Closeable)stream);
            }
            return true;
        }
        catch (IOException e) {
            String msg = "Unable to read transaction ids " + firstTxIdInLogs + "-" + curTxIdOnOtherNode + " from the configured shared edits storage " + Joiner.on((String)",").join(this.sharedEditsUris) + ". " + "Please copy these logs into the shared edits storage " + "or call saveNamespace on the active node.\n" + "Error: " + e.getLocalizedMessage();
            LOG.fatal((Object)msg, (Throwable)e);
            return false;
        }
    }

    private boolean checkLayoutVersion(NamespaceInfo nsInfo) throws IOException {
        return nsInfo.getLayoutVersion() == HdfsServerConstants.NAMENODE_LAYOUT_VERSION;
    }

    private void parseConfAndFindOtherNN() throws IOException {
        Configuration conf = this.getConf();
        this.nsId = DFSUtil.getNamenodeNameServiceId(conf);
        if (!HAUtil.isHAEnabled(conf, this.nsId)) {
            throw new HadoopIllegalArgumentException("HA is not enabled for this namenode.");
        }
        this.nnId = HAUtil.getNameNodeId(conf, this.nsId);
        NameNode.initializeGenericKeys(conf, this.nsId, this.nnId);
        if (!HAUtil.usesSharedEditsDir(conf)) {
            throw new HadoopIllegalArgumentException("Shared edits storage is not enabled for this namenode.");
        }
        Configuration otherNode = HAUtil.getConfForOtherNode(conf);
        this.otherNNId = HAUtil.getNameNodeId(otherNode, this.nsId);
        this.otherIpcAddr = NameNode.getServiceAddress(otherNode, true);
        Preconditions.checkArgument((this.otherIpcAddr.getPort() != 0 && !this.otherIpcAddr.getAddress().isAnyLocalAddress() ? 1 : 0) != 0, (String)"Could not determine valid IPC address for other NameNode (%s), got: %s", (Object[])new Object[]{this.otherNNId, this.otherIpcAddr});
        String scheme = DFSUtil.getHttpClientScheme(conf);
        this.otherHttpAddr = DFSUtil.getInfoServerWithDefaultHost(this.otherIpcAddr.getHostName(), otherNode, scheme).toURL();
        this.dirsToFormat = FSNamesystem.getNamespaceDirs(conf);
        this.editUrisToFormat = FSNamesystem.getNamespaceEditsDirs(conf, false);
        this.sharedEditsUris = FSNamesystem.getSharedEditsDirs(conf);
    }

    public void setConf(Configuration conf) {
        this.conf = DFSHAAdmin.addSecurityConfiguration(conf);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public static int run(String[] argv, Configuration conf) throws IOException {
        BootstrapStandby bs = new BootstrapStandby();
        bs.setConf(conf);
        try {
            return ToolRunner.run((Tool)bs, (String[])argv);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }
}

