/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;

public class TestBlocksWithNotEnoughRacks {
    public static final Log LOG = LogFactory.getLog(TestBlocksWithNotEnoughRacks.class);

    private Configuration getConf() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setInt("dfs.namenode.replication.interval", 1);
        conf.setInt("dfs.namenode.replication.pending.timeout-sec", 1);
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.set("net.topology.script.file.name", "xyz");
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSufficientlyReplBlocksUsesNewRack() throws Exception {
        Configuration conf = this.getConf();
        int REPLICATION_FACTOR = 3;
        Path filePath = new Path("/testFile");
        String[] racks = new String[]{"/rack1", "/rack1", "/rack1"};
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(racks.length).racks(racks).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, (short)3, 1L);
            ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            DFSTestUtil.waitForReplication(cluster, b, 1, 3, 0);
            String[] newRacks = new String[]{"/rack2"};
            cluster.startDataNodes(conf, 1, true, null, newRacks);
            cluster.waitActive();
            DFSTestUtil.waitForReplication(cluster, b, 2, 3, 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSufficientlySingleReplBlockUsesNewRack() throws Exception {
        Configuration conf = this.getConf();
        short REPLICATION_FACTOR = 1;
        Path filePath = new Path("/testFile");
        String[] racks = new String[]{"/rack1", "/rack1", "/rack1", "/rack2"};
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(racks.length).racks(racks).build();
        FSNamesystem ns = cluster.getNameNode().getNamesystem();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, REPLICATION_FACTOR, 1L);
            ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            DFSTestUtil.waitForReplication(cluster, b, 1, REPLICATION_FACTOR, 0);
            REPLICATION_FACTOR = 2;
            NameNodeAdapter.setReplication(ns, "/testFile", REPLICATION_FACTOR);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnderReplicatedUsesNewRacks() throws Exception {
        Configuration conf = this.getConf();
        short REPLICATION_FACTOR = 3;
        Path filePath = new Path("/testFile");
        String[] racks = new String[]{"/rack1", "/rack1", "/rack1", "/rack1", "/rack1"};
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(racks.length).racks(racks).build();
        FSNamesystem ns = cluster.getNameNode().getNamesystem();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, REPLICATION_FACTOR, 1L);
            ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            DFSTestUtil.waitForReplication(cluster, b, 1, REPLICATION_FACTOR, 0);
            String[] newRacks = new String[]{"/rack2", "/rack2"};
            cluster.startDataNodes(conf, 2, true, null, newRacks);
            REPLICATION_FACTOR = 5;
            NameNodeAdapter.setReplication(ns, "/testFile", REPLICATION_FACTOR);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCorruptBlockRereplicatedAcrossRacks() throws Exception {
        Configuration conf = this.getConf();
        short REPLICATION_FACTOR = 2;
        int fileLen = 512;
        Path filePath = new Path("/testFile");
        String[] racks = new String[]{"/rack1", "/rack1", "/rack2", "/rack2"};
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(racks.length).racks(racks).build();
        FSNamesystem ns = cluster.getNameNode().getNamesystem();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, filePath, fileLen, REPLICATION_FACTOR, 1L);
            String fileContent = DFSTestUtil.readFile((FileSystem)fs, filePath);
            ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
            int dnToCorrupt = DFSTestUtil.firstDnWithBlock(cluster, b);
            Assert.assertTrue((boolean)MiniDFSCluster.corruptReplica(dnToCorrupt, b));
            cluster.restartDataNode(dnToCorrupt);
            DFSTestUtil.waitCorruptReplicas((FileSystem)fs, ns, filePath, b, 1);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
            for (int i = 0; i < racks.length; ++i) {
                String blockContent = cluster.readBlockOnDataNode(i, b);
                if (blockContent == null || i == dnToCorrupt) continue;
                Assert.assertEquals((String)"Corrupt replica", (Object)fileContent, (Object)blockContent);
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReduceReplFactorRespectsRackPolicy() throws Exception {
        Configuration conf = this.getConf();
        short REPLICATION_FACTOR = 3;
        Path filePath = new Path("/testFile");
        String[] racks = new String[]{"/rack1", "/rack1", "/rack2", "/rack2"};
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(racks.length).racks(racks).build();
        FSNamesystem ns = cluster.getNameNode().getNamesystem();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, REPLICATION_FACTOR, 1L);
            ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
            REPLICATION_FACTOR = 2;
            NameNodeAdapter.setReplication(ns, "/testFile", REPLICATION_FACTOR);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplDueToNodeFailRespectsRackPolicy() throws Exception {
        Configuration conf = this.getConf();
        short REPLICATION_FACTOR = 3;
        Path filePath = new Path("/testFile");
        String[] racks = new String[]{"/rack1", "/rack1", "/rack1", "/rack2", "/rack2"};
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(racks.length).racks(racks).build();
        FSNamesystem ns = cluster.getNameNode().getNamesystem();
        DatanodeManager dm = ns.getBlockManager().getDatanodeManager();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, REPLICATION_FACTOR, 1L);
            ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            int idx = datanodes.size() - 1;
            DataNode dataNode = datanodes.get(idx);
            DatanodeID dnId = dataNode.getDatanodeId();
            cluster.stopDataNode(idx);
            dm.removeDatanode(dnId);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
            datanodes = cluster.getDataNodes();
            idx = datanodes.size() - 1;
            dataNode = datanodes.get(idx);
            dnId = dataNode.getDatanodeId();
            cluster.stopDataNode(idx);
            dm.removeDatanode(dnId);
            DFSTestUtil.waitForReplication(cluster, b, 1, REPLICATION_FACTOR, 1);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReduceReplFactorDueToRejoinRespectsRackPolicy() throws Exception {
        Configuration conf = this.getConf();
        short REPLICATION_FACTOR = 2;
        Path filePath = new Path("/testFile");
        String[] racks = new String[]{"/rack1", "/rack1", "/rack2"};
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(racks.length).racks(racks).build();
        FSNamesystem ns = cluster.getNameNode().getNamesystem();
        DatanodeManager dm = ns.getBlockManager().getDatanodeManager();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, REPLICATION_FACTOR, 1L);
            ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            Assert.assertEquals((long)3L, (long)datanodes.size());
            DataNode dataNode = datanodes.get(2);
            DatanodeID dnId = dataNode.getDatanodeId();
            cluster.stopDataNode(2);
            dm.removeDatanode(dnId);
            DFSTestUtil.waitForReplication(cluster, b, 1, REPLICATION_FACTOR, 1);
            String[] rack2 = new String[]{"/rack2"};
            cluster.startDataNodes(conf, 1, true, null, rack2);
            cluster.waitActive();
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNodeDecomissionRespectsRackPolicy() throws Exception {
        Configuration conf = this.getConf();
        short REPLICATION_FACTOR = 2;
        Path filePath = new Path("/testFile");
        LocalFileSystem localFileSys = FileSystem.getLocal((Configuration)conf);
        Path workingDir = localFileSys.getWorkingDirectory();
        Path dir = new Path(workingDir, "build/test/data/temp/decommission");
        Path excludeFile = new Path(dir, "exclude");
        Path includeFile = new Path(dir, "include");
        Assert.assertTrue((boolean)localFileSys.mkdirs(dir));
        DFSTestUtil.writeFile((FileSystem)localFileSys, excludeFile, "");
        DFSTestUtil.writeFile((FileSystem)localFileSys, includeFile, "");
        conf.set("dfs.hosts.exclude", excludeFile.toUri().getPath());
        conf.set("dfs.hosts", includeFile.toUri().getPath());
        String[] racks = new String[]{"/rack1", "/rack1", "/rack2", "/rack2"};
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(racks.length).racks(racks).build();
        FSNamesystem ns = cluster.getNameNode().getNamesystem();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, REPLICATION_FACTOR, 1L);
            ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
            BlockLocation[] locs = fs.getFileBlockLocations(fs.getFileStatus(filePath), 0L, Long.MAX_VALUE);
            String name = locs[0].getNames()[0];
            DFSTestUtil.writeFile((FileSystem)localFileSys, excludeFile, name);
            ns.getBlockManager().getDatanodeManager().refreshNodes(conf);
            DFSTestUtil.waitForDecommission((FileSystem)fs, name);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNodeDecomissionWithOverreplicationRespectsRackPolicy() throws Exception {
        Configuration conf = this.getConf();
        short REPLICATION_FACTOR = 5;
        Path filePath = new Path("/testFile");
        LocalFileSystem localFileSys = FileSystem.getLocal((Configuration)conf);
        Path workingDir = localFileSys.getWorkingDirectory();
        Path dir = new Path(workingDir, "build/test/data/temp/decommission");
        Path excludeFile = new Path(dir, "exclude");
        Path includeFile = new Path(dir, "include");
        Assert.assertTrue((boolean)localFileSys.mkdirs(dir));
        DFSTestUtil.writeFile((FileSystem)localFileSys, excludeFile, "");
        DFSTestUtil.writeFile((FileSystem)localFileSys, includeFile, "");
        conf.set("dfs.hosts", includeFile.toUri().getPath());
        conf.set("dfs.hosts.exclude", excludeFile.toUri().getPath());
        String[] racks = new String[]{"/rack1", "/rack2", "/rack1", "/rack1", "/rack1"};
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(racks.length).racks(racks).build();
        FSNamesystem ns = cluster.getNameNode().getNamesystem();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, REPLICATION_FACTOR, 1L);
            ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
            REPLICATION_FACTOR = 2;
            fs.setReplication(filePath, REPLICATION_FACTOR);
            BlockLocation[] locs = fs.getFileBlockLocations(fs.getFileStatus(filePath), 0L, Long.MAX_VALUE);
            for (String top : locs[0].getTopologyPaths()) {
                if (top.startsWith("/rack2")) continue;
                String name = top.substring("/rack1".length() + 1);
                DFSTestUtil.writeFile((FileSystem)localFileSys, excludeFile, name);
                ns.getBlockManager().getDatanodeManager().refreshNodes(conf);
                DFSTestUtil.waitForDecommission((FileSystem)fs, name);
                break;
            }
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    static {
        ((Log4JLogger)LogFactory.getLog(FSNamesystem.class)).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LOG).getLogger().setLevel(Level.ALL);
    }
}

