/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.io.IOUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestMetaSave {
    static final int NUM_DATA_NODES = 2;
    static final long seed = 3735928559L;
    static final int blockSize = 8192;
    private static MiniDFSCluster cluster = null;
    private static FileSystem fileSys = null;
    private static FSNamesystem namesystem = null;

    private void createFile(FileSystem fileSys, Path name) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)2, 8192L);
        byte[] buffer = new byte[1024];
        Random rand = new Random(3735928559L);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.close();
    }

    @BeforeClass
    public static void setUp() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.replication.interval", 1000);
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setLong("dfs.namenode.heartbeat.recheck-interval", 1L);
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        cluster.waitActive();
        fileSys = cluster.getFileSystem();
        namesystem = cluster.getNamesystem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaSave() throws IOException, InterruptedException {
        for (int i = 0; i < 2; ++i) {
            Path file = new Path("/filestatus" + i);
            this.createFile(fileSys, file);
        }
        cluster.stopDataNode(1);
        Thread.sleep(15000L);
        namesystem.setReplication("/filestatus0", (short)4);
        namesystem.metaSave("metasave.out.txt");
        FileInputStream fstream = new FileInputStream(TestMetaSave.getLogFile("metasave.out.txt"));
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in));
            String line = reader.readLine();
            Assert.assertTrue((boolean)line.equals("3 files and directories, 2 blocks = 5 total"));
            line = reader.readLine();
            Assert.assertTrue((boolean)line.equals("Live Datanodes: 1"));
            line = reader.readLine();
            Assert.assertTrue((boolean)line.equals("Dead Datanodes: 1"));
            line = reader.readLine();
            line = reader.readLine();
            Assert.assertTrue((boolean)line.matches("^/filestatus[01]:.*"));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetasaveAfterDelete() throws IOException, InterruptedException {
        for (int i = 0; i < 2; ++i) {
            Path file = new Path("/filestatus" + i);
            this.createFile(fileSys, file);
        }
        cluster.stopDataNode(1);
        Thread.sleep(15000L);
        namesystem.setReplication("/filestatus0", (short)4);
        namesystem.delete("/filestatus0", true);
        namesystem.delete("/filestatus1", true);
        namesystem.metaSave("metasaveAfterDelete.out.txt");
        BufferedReader reader = null;
        try {
            FileInputStream fstream = new FileInputStream(TestMetaSave.getLogFile("metasaveAfterDelete.out.txt"));
            DataInputStream in = new DataInputStream(fstream);
            reader = new BufferedReader(new InputStreamReader(in));
            reader.readLine();
            String line = reader.readLine();
            Assert.assertTrue((boolean)line.equals("Live Datanodes: 1"));
            line = reader.readLine();
            Assert.assertTrue((boolean)line.equals("Dead Datanodes: 1"));
            line = reader.readLine();
            Assert.assertTrue((boolean)line.equals("Metasave: Blocks waiting for replication: 0"));
            line = reader.readLine();
            Assert.assertTrue((boolean)line.equals("Mis-replicated blocks that have been postponed:"));
            line = reader.readLine();
            Assert.assertTrue((boolean)line.equals("Metasave: Blocks being replicated: 0"));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaSaveOverwrite() throws Exception {
        namesystem.metaSave("metaSaveOverwrite.out.txt");
        namesystem.metaSave("metaSaveOverwrite.out.txt");
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader rdr = null;
        try {
            fis = new FileInputStream(TestMetaSave.getLogFile("metaSaveOverwrite.out.txt"));
            isr = new InputStreamReader(fis);
            rdr = new BufferedReader(isr);
            boolean foundLiveDatanodesLine = false;
            String line = rdr.readLine();
            while (line != null) {
                if (line.startsWith("Live Datanodes")) {
                    if (foundLiveDatanodesLine) {
                        Assert.fail((String)"multiple Live Datanodes lines, output file not overwritten");
                    }
                    foundLiveDatanodesLine = true;
                }
                line = rdr.readLine();
            }
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{rdr, isr, fis});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{rdr, isr, fis});
    }

    @AfterClass
    public static void tearDown() throws IOException {
        if (fileSys != null) {
            fileSys.close();
        }
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    private static File getLogFile(String name) {
        return new File(System.getProperty("hadoop.log.dir"), name);
    }
}

