/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.hdfs.util.ChunkedArrayList;
import org.junit.Assert;
import org.junit.Test;

public class TestChunkedArrayList {
    @Test
    public void testBasics() {
        int N_ELEMS = 100000;
        ChunkedArrayList l = new ChunkedArrayList();
        Assert.assertTrue((boolean)l.isEmpty());
        for (int i = 0; i < 100000; ++i) {
            l.add((Object)i);
        }
        Assert.assertFalse((boolean)l.isEmpty());
        Assert.assertEquals((long)100000L, (long)l.size());
        Assert.assertTrue((l.getNumChunks() > 10 ? 1 : 0) != 0);
        Assert.assertEquals((long)8192L, (long)l.getMaxChunkSize());
    }

    @Test
    public void testIterator() {
        int i;
        ChunkedArrayList l = new ChunkedArrayList();
        for (i = 0; i < 30000; ++i) {
            l.add((Object)i);
        }
        i = 0;
        Iterator i$ = l.iterator();
        while (i$.hasNext()) {
            int fromList = (Integer)i$.next();
            Assert.assertEquals((long)i, (long)fromList);
            ++i;
        }
    }

    @Test
    public void testPerformance() {
        String obj = "hello world";
        int numElems = 1000000;
        int numTrials = 5;
        for (int trial = 0; trial < 5; ++trial) {
            int i;
            System.gc();
            ArrayList<String> arrayList = new ArrayList<String>();
            Stopwatch sw = new Stopwatch();
            sw.start();
            for (i = 0; i < 1000000; ++i) {
                arrayList.add(obj);
            }
            System.out.println("       ArrayList " + sw.elapsedMillis());
            System.gc();
            ChunkedArrayList chunkedList = new ChunkedArrayList();
            sw = new Stopwatch();
            sw.start();
            for (i = 0; i < 1000000; ++i) {
                chunkedList.add((Object)obj);
            }
            System.out.println("ChunkedArrayList " + sw.elapsedMillis());
        }
    }
}

