/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.util.MD5FileUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.test.PathUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestMD5FileUtils {
    private static final File TEST_DIR = PathUtils.getTestDir(TestMD5FileUtils.class);
    private static final File TEST_FILE = new File(TEST_DIR, "testMd5File.dat");
    private static final int TEST_DATA_LEN = 131072;
    private static final byte[] TEST_DATA = DFSTestUtil.generateSequentialBytes(0, 131072);
    private static final MD5Hash TEST_MD5 = MD5Hash.digest((byte[])TEST_DATA);

    @Before
    public void setup() throws IOException {
        FileUtil.fullyDelete((File)TEST_DIR);
        Assert.assertTrue((boolean)TEST_DIR.mkdirs());
        FileOutputStream fos = new FileOutputStream(TEST_FILE);
        fos.write(TEST_DATA);
        fos.close();
    }

    @Test
    public void testComputeMd5ForFile() throws Exception {
        MD5Hash computedDigest = MD5FileUtils.computeMd5ForFile((File)TEST_FILE);
        Assert.assertEquals((Object)TEST_MD5, (Object)computedDigest);
    }

    @Test
    public void testVerifyMD5FileGood() throws Exception {
        MD5FileUtils.saveMD5File((File)TEST_FILE, (MD5Hash)TEST_MD5);
        MD5FileUtils.verifySavedMD5((File)TEST_FILE, (MD5Hash)TEST_MD5);
    }

    @Test(expected=IOException.class)
    public void testVerifyMD5FileMissing() throws Exception {
        MD5FileUtils.verifySavedMD5((File)TEST_FILE, (MD5Hash)TEST_MD5);
    }

    @Test
    public void testVerifyMD5FileBadDigest() throws Exception {
        MD5FileUtils.saveMD5File((File)TEST_FILE, (MD5Hash)MD5Hash.digest((byte[])new byte[0]));
        try {
            MD5FileUtils.verifySavedMD5((File)TEST_FILE, (MD5Hash)TEST_MD5);
            Assert.fail((String)"Did not throw");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVerifyMD5FileBadFormat() throws Exception {
        FileWriter writer = new FileWriter(MD5FileUtils.getDigestFileForFile((File)TEST_FILE));
        try {
            writer.write("this is not an md5 file");
        }
        finally {
            writer.close();
        }
        try {
            MD5FileUtils.verifySavedMD5((File)TEST_FILE, (MD5Hash)TEST_MD5);
            Assert.fail((String)"Did not throw");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

