/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.plugin.jdbc.tdengine;

import io.edurt.datacap.plugin.jdbc.tdengine.TDengineAdapter;
import io.edurt.datacap.spi.Plugin;
import io.edurt.datacap.spi.PluginType;
import io.edurt.datacap.spi.connection.JdbcConfigure;
import io.edurt.datacap.spi.connection.JdbcConnection;
import io.edurt.datacap.spi.model.Configure;
import io.edurt.datacap.spi.model.Response;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDenginePlugin
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(TDenginePlugin.class);
    private JdbcConfigure jdbcConfigure;
    private JdbcConnection connection;
    private Response response;

    public String name() {
        return "TDengine";
    }

    public String description() {
        return "Integrate TDengine data sources";
    }

    public PluginType type() {
        return PluginType.JDBC;
    }

    public void connect(Configure configure) {
        try {
            this.response = new Response();
            this.jdbcConfigure = new JdbcConfigure();
            BeanUtils.copyProperties((Object)this.jdbcConfigure, (Object)configure);
            this.jdbcConfigure.setJdbcDriver("com.taosdata.jdbc.TSDBDriver");
            this.jdbcConfigure.setJdbcType("TAOS-RS");
            this.connection = new JdbcConnection(this.jdbcConfigure, this.response);
        }
        catch (Exception ex) {
            this.response.setIsConnected(Boolean.FALSE);
            this.response.setMessage(ex.getMessage());
        }
    }

    public Response execute(String content) {
        if (ObjectUtils.isNotEmpty((Object)this.connection)) {
            log.info("Execute tdengine plugin logic started");
            this.response = this.connection.getResponse();
            TDengineAdapter processor = new TDengineAdapter(this.connection);
            this.response = processor.handlerExecute(content);
            log.info("Execute tdengine plugin logic end");
        }
        return this.response;
    }

    public void destroy() {
        if (ObjectUtils.isNotEmpty((Object)this.connection)) {
            this.connection.destroy();
        }
    }
}

