/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.plugin.jdbc.clickhouse;

import io.edurt.datacap.plugin.jdbc.clickhouse.ClickHouseAdapter;
import io.edurt.datacap.plugin.jdbc.clickhouse.ClickHouseConnection;
import io.edurt.datacap.spi.Plugin;
import io.edurt.datacap.spi.PluginType;
import io.edurt.datacap.spi.connection.JdbcConfigure;
import io.edurt.datacap.spi.model.Configure;
import io.edurt.datacap.spi.model.Response;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickHousePlugin
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(ClickHousePlugin.class);
    private JdbcConfigure jdbcConfigure;
    private ClickHouseConnection clickHouseConnection;
    private Response response;

    public String name() {
        return "ClickHouse";
    }

    public String description() {
        return "Integrate ClickHouse data sources";
    }

    public PluginType type() {
        return PluginType.JDBC;
    }

    public void connect(Configure configure) {
        try {
            this.response = new Response();
            this.jdbcConfigure = new JdbcConfigure();
            BeanUtils.copyProperties((Object)this.jdbcConfigure, (Object)configure);
            this.jdbcConfigure.setJdbcDriver("ru.yandex.clickhouse.ClickHouseDriver");
            this.jdbcConfigure.setJdbcType("clickhouse");
            this.clickHouseConnection = new ClickHouseConnection(this.jdbcConfigure, this.response);
        }
        catch (Exception ex) {
            this.response.setIsConnected(Boolean.FALSE);
            this.response.setMessage(ex.getMessage());
        }
    }

    public Response execute(String content) {
        if (ObjectUtils.isNotEmpty((Object)((Object)this.clickHouseConnection))) {
            log.info("Execute clickhouse plugin logic started");
            this.response = this.clickHouseConnection.getResponse();
            ClickHouseAdapter processor = new ClickHouseAdapter(this.clickHouseConnection);
            this.response = processor.handlerExecute(content);
            log.info("Execute clickhouse plugin logic end");
        }
        return this.response;
    }

    public void destroy() {
        if (ObjectUtils.isNotEmpty((Object)((Object)this.clickHouseConnection))) {
            this.clickHouseConnection.destroy();
        }
    }
}

