/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.recovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerNodemanagerRecoveryProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class NMStateStoreService
extends AbstractService {
    public NMStateStoreService(String name) {
        super(name);
    }

    public void serviceInit(Configuration conf) throws IOException {
        this.initStorage(conf);
    }

    public void serviceStart() throws IOException {
        this.startStorage();
    }

    public void serviceStop() throws IOException {
        this.closeStorage();
    }

    public boolean canRecover() {
        return true;
    }

    public abstract RecoveredLocalizationState loadLocalizationState() throws IOException;

    public abstract void startResourceLocalization(String var1, ApplicationId var2, YarnProtos.LocalResourceProto var3, Path var4) throws IOException;

    public abstract void finishResourceLocalization(String var1, ApplicationId var2, YarnServerNodemanagerRecoveryProtos.LocalizedResourceProto var3) throws IOException;

    public abstract void removeLocalizedResource(String var1, ApplicationId var2, Path var3) throws IOException;

    public abstract RecoveredDeletionServiceState loadDeletionServiceState() throws IOException;

    public abstract void storeDeletionTask(int var1, YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto var2) throws IOException;

    public abstract void removeDeletionTask(int var1) throws IOException;

    protected abstract void initStorage(Configuration var1) throws IOException;

    protected abstract void startStorage() throws IOException;

    protected abstract void closeStorage() throws IOException;

    public static class RecoveredDeletionServiceState {
        List<YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto> tasks;

        public List<YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto> getTasks() {
            return this.tasks;
        }
    }

    public static class RecoveredLocalizationState {
        LocalResourceTrackerState publicTrackerState = new LocalResourceTrackerState();
        Map<String, RecoveredUserResources> userResources = new HashMap<String, RecoveredUserResources>();

        public LocalResourceTrackerState getPublicTrackerState() {
            return this.publicTrackerState;
        }

        public Map<String, RecoveredUserResources> getUserResources() {
            return this.userResources;
        }
    }

    public static class RecoveredUserResources {
        LocalResourceTrackerState privateTrackerState = new LocalResourceTrackerState();
        Map<ApplicationId, LocalResourceTrackerState> appTrackerStates = new HashMap<ApplicationId, LocalResourceTrackerState>();

        public LocalResourceTrackerState getPrivateTrackerState() {
            return this.privateTrackerState;
        }

        public Map<ApplicationId, LocalResourceTrackerState> getAppTrackerStates() {
            return this.appTrackerStates;
        }
    }

    public static class LocalResourceTrackerState {
        List<YarnServerNodemanagerRecoveryProtos.LocalizedResourceProto> localizedResources = new ArrayList<YarnServerNodemanagerRecoveryProtos.LocalizedResourceProto>();
        Map<YarnProtos.LocalResourceProto, Path> inProgressResources = new HashMap<YarnProtos.LocalResourceProto, Path>();

        public List<YarnServerNodemanagerRecoveryProtos.LocalizedResourceProto> getLocalizedResources() {
            return this.localizedResources;
        }

        public Map<YarnProtos.LocalResourceProto, Path> getInProgressResources() {
            return this.inProgressResources;
        }

        public boolean isEmpty() {
            return this.localizedResources.isEmpty() && this.inProgressResources.isEmpty();
        }
    }
}

