/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.mongodb.jdbc.NoCheckStateJsonWriter;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.LoggingAspect$ajcMightHaveAspect;
import java.io.StringWriter;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.BsonValueCodec;
import org.bson.codecs.EncoderContext;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;

public class MongoSQLBsonValue
implements LoggingAspect$ajcMightHaveAspect {
    static final JsonWriterSettings JSON_WRITER_SETTINGS;
    static final EncoderContext ENCODER_CONTEXT;
    private BsonValue v;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private transient /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;

    static {
        MongoSQLBsonValue.ajc$preClinit();
        JSON_WRITER_SETTINGS = JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).build();
        ENCODER_CONTEXT = EncoderContext.builder().build();
    }

    public MongoSQLBsonValue(BsonValue v) {
        LoggingAspect.ajc$perObjectBind(this);
        this.v = v;
    }

    public BsonValue getBsonValue() {
        try {
            return this.v;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    public String toString() {
        try {
            if (this.v == null) {
                return null;
            }
            switch (this.v.getBsonType()) {
                case NULL: {
                    return null;
                }
                case UNDEFINED: {
                    return null;
                }
                case STRING: {
                    return this.v.asString().getValue();
                }
                case DOCUMENT: 
                case ARRAY: 
                case BINARY: 
                case OBJECT_ID: 
                case DATE_TIME: 
                case REGULAR_EXPRESSION: 
                case DB_POINTER: 
                case JAVASCRIPT: 
                case SYMBOL: 
                case JAVASCRIPT_WITH_SCOPE: 
                case TIMESTAMP: 
                case DECIMAL128: 
                case MIN_KEY: 
                case MAX_KEY: {
                    return this.toExtendedJson(this.v);
                }
                case DOUBLE: 
                case BOOLEAN: 
                case INT32: 
                case INT64: {
                    BsonDocument v = new BsonDocument("v", this.v);
                    String s = this.toExtendedJson((BsonValue)v);
                    return s.substring(6, s.length() - 1);
                }
            }
            return this.v.toString();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    private String toExtendedJson(BsonValue v) {
        try {
            BsonValueCodec c = new BsonValueCodec();
            StringWriter w = new StringWriter();
            c.encode((BsonWriter)new NoCheckStateJsonWriter(w, JSON_WRITER_SETTINGS), v, ENCODER_CONTEXT);
            w.flush();
            return w.toString();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    public int hashCode() {
        try {
            return this.v.hashCode();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_3);
            }
            throw exception;
        }
    }

    public boolean equals(Object o) {
        try {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.v.equals(((MongoSQLBsonValue)o).v);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_4);
            }
            throw exception;
        }
    }

    @Override
    public /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet() {
        return this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;
    }

    @Override
    public /* synthetic */ void ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectSet(LoggingAspect loggingAspect) {
        this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField = loggingAspect;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MongoSQLBsonValue.java", MongoSQLBsonValue.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBsonValue", "com.mongodb.jdbc.MongoSQLBsonValue", "", "", "", "org.bson.BsonValue"), 48);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "com.mongodb.jdbc.MongoSQLBsonValue", "", "", "", "java.lang.String"), 53);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toExtendedJson", "com.mongodb.jdbc.MongoSQLBsonValue", "org.bson.BsonValue", "v", "", "java.lang.String"), 115);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hashCode", "com.mongodb.jdbc.MongoSQLBsonValue", "", "", "", "int"), 124);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "equals", "com.mongodb.jdbc.MongoSQLBsonValue", "java.lang.Object", "o", "", "boolean"), 129);
    }
}

