/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.mongodb.jdbc.MongoConnection;
import com.mongodb.jdbc.MongoConnectionProperties;
import com.mongodb.jdbc.MongoPreparedStatement;
import com.mongodb.jdbc.MySQLDatabaseMetaData;
import com.mongodb.jdbc.MySQLStatement;
import com.mongodb.jdbc.logging.AutoLoggable;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.LoggingAspect$ajcMightHaveAspect;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@AutoLoggable
public class MySQLConnection
extends MongoConnection
implements Connection,
LoggingAspect$ajcMightHaveAspect {
    private boolean relaxed;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private transient /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;

    public MySQLConnection(MongoConnectionProperties mongoConnectionProperties, String conversionMode) {
        super(mongoConnectionProperties);
        LoggingAspect.ajc$perObjectBind(this);
        super.getLogger().log(Level.INFO, "Dialect is Mysql");
        this.relaxed = conversionMode == null || !conversionMode.equals("strict");
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this));
            }
            this.checkConnection();
            try {
                return new MySQLStatement(this, this.currentDB, this.relaxed);
            }
            catch (IllegalArgumentException e) {
                throw new SQLException(e);
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        String string = sql;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string));
            }
            this.checkConnection();
            try {
                return new MongoPreparedStatement(sql, new MySQLStatement(this, this.currentDB, this.relaxed));
            }
            catch (IllegalArgumentException e) {
                throw new SQLException(e);
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this));
            }
            return new MySQLDatabaseMetaData(this);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    static {
        MySQLConnection.ajc$preClinit();
    }

    @Override
    public /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet() {
        return this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;
    }

    @Override
    public /* synthetic */ void ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectSet(LoggingAspect loggingAspect) {
        this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField = loggingAspect;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MySQLConnection.java", MySQLConnection.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createStatement", "com.mongodb.jdbc.MySQLConnection", "", "", "java.sql.SQLException", "java.sql.Statement"), 39);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "prepareStatement", "com.mongodb.jdbc.MySQLConnection", "java.lang.String", "sql", "java.sql.SQLException", "java.sql.PreparedStatement"), 49);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMetaData", "com.mongodb.jdbc.MySQLConnection", "", "", "java.sql.SQLException", "java.sql.DatabaseMetaData"), 59);
    }
}

