/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.google.common.base.Preconditions;
import com.mongodb.client.MongoCursor;
import com.mongodb.jdbc.MongoResultSet;
import com.mongodb.jdbc.MongoStatement;
import com.mongodb.jdbc.MySQLResultDoc;
import com.mongodb.jdbc.MySQLResultSetMetaData;
import com.mongodb.jdbc.logging.AutoLoggable;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.LoggingAspect$ajcMightHaveAspect;
import com.mongodb.jdbc.logging.MongoLogger;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.text.ParseException;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.types.Decimal128;

@AutoLoggable
public class MySQLResultSet
extends MongoResultSet<MySQLResultDoc>
implements ResultSet,
LoggingAspect$ajcMightHaveAspect {
    private boolean relaxed;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private transient /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;

    public MySQLResultSet(MongoStatement statement, MongoCursor<MySQLResultDoc> cursor, boolean relaxed) throws SQLException {
        super(statement);
        LoggingAspect.ajc$perObjectBind(this);
        this.relaxed = true;
        this.setupResultset(cursor, relaxed);
        MySQLResultDoc metadataDoc = (MySQLResultDoc)cursor.next();
        this.rsMetaData = new MySQLResultSetMetaData(metadataDoc, statement.getParentLogger(), statement.getStatementId());
    }

    public MySQLResultSet(MongoLogger parentLogger, MongoCursor<MySQLResultDoc> cursor, boolean relaxed) throws SQLException {
        super(parentLogger);
        LoggingAspect.ajc$perObjectBind(this);
        this.relaxed = true;
        this.setupResultset(cursor, relaxed);
        MySQLResultDoc metadataDoc = (MySQLResultDoc)cursor.next();
        this.rsMetaData = new MySQLResultSetMetaData(metadataDoc, parentLogger, null);
    }

    private void setupResultset(MongoCursor<MySQLResultDoc> cursor, boolean relaxed) throws SQLException {
        try {
            Preconditions.checkNotNull(cursor);
            this.cursor = cursor;
            this.relaxed = relaxed;
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    @Override
    protected boolean checkNull(BsonValue o) {
        try {
            this.wasNull = false;
            if (o == null) {
                this.wasNull = true;
                return true;
            }
            BsonType ty = o.getBsonType();
            if (!this.relaxed) {
                switch (ty) {
                    case UNDEFINED: 
                    case NULL: {
                        this.wasNull = true;
                        return true;
                    }
                }
                return false;
            }
            switch (ty) {
                case END_OF_DOCUMENT: 
                case DOCUMENT: 
                case ARRAY: 
                case UNDEFINED: 
                case NULL: 
                case REGULAR_EXPRESSION: 
                case DB_POINTER: 
                case JAVASCRIPT: 
                case SYMBOL: 
                case JAVASCRIPT_WITH_SCOPE: 
                case TIMESTAMP: 
                case MIN_KEY: 
                case MAX_KEY: {
                    this.wasNull = true;
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    @Override
    protected BsonValue getBsonValue(int columnIndex) throws SQLException {
        try {
            this.checkBounds(columnIndex);
            return ((MySQLResultDoc)this.current).values.get(columnIndex - 1);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    @Override
    protected BsonValue getBsonValue(String columnLabel) throws SQLException {
        try {
            return this.getBsonValue(this.findColumn(columnLabel));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_3);
            }
            throw exception;
        }
    }

    @Override
    protected Object getObject(BsonValue o, int columnType) throws SQLException {
        try {
            if (this.checkNull(o)) {
                return null;
            }
            switch (columnType) {
                case 2003: {
                    break;
                }
                case -5: {
                    return this.getInt(o);
                }
                case -2: {
                    break;
                }
                case -7: {
                    return this.getBoolean(o);
                }
                case 2004: {
                    break;
                }
                case 16: {
                    return this.getBoolean(o);
                }
                case 1: {
                    break;
                }
                case 2005: {
                    break;
                }
                case 70: {
                    break;
                }
                case 91: {
                    break;
                }
                case 3: {
                    return this.getBigDecimal(o);
                }
                case 2001: {
                    break;
                }
                case 8: {
                    return this.getDouble(o);
                }
                case 6: {
                    return Float.valueOf(this.getFloat(o));
                }
                case 4: {
                    return this.getInt(o);
                }
                case 2000: {
                    break;
                }
                case -16: {
                    return this.getString(o);
                }
                case -4: {
                    break;
                }
                case -1: {
                    return this.getString(o);
                }
                case -15: {
                    return this.getString(o);
                }
                case 2011: {
                    break;
                }
                case 0: {
                    return null;
                }
                case 2: {
                    return this.getDouble(o);
                }
                case -9: {
                    return this.getString(o);
                }
                case 1111: {
                    break;
                }
                case 7: {
                    break;
                }
                case 2006: {
                    break;
                }
                case 2012: {
                    break;
                }
                case -8: {
                    break;
                }
                case 5: {
                    return this.getInt(o);
                }
                case 2009: {
                    break;
                }
                case 2002: {
                    break;
                }
                case 92: {
                    break;
                }
                case 2013: {
                    break;
                }
                case 93: {
                    return this.getTimestamp(o);
                }
                case 2014: {
                    break;
                }
                case -6: {
                    return this.getInt(o);
                }
                case -3: {
                    break;
                }
                case 12: {
                    return this.getString(o);
                }
            }
            throw new SQLException("getObject not supported for column type " + columnType);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_4);
            }
            throw exception;
        }
    }

    @Override
    protected byte[] handleBytesConversionFailure(String from) throws SQLException {
        try {
            if (this.relaxed) {
                return null;
            }
            throw new SQLException("The " + from + " type cannot be converted to blob.");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_5);
            }
            throw exception;
        }
    }

    @Override
    protected byte[] getBytes(BsonValue o) throws SQLException {
        try {
            if (this.checkNull(o)) {
                return null;
            }
            switch (o.getBsonType()) {
                case ARRAY: {
                    return this.handleBytesConversionFailure("array");
                }
                case BINARY: {
                    return o.asBinary().getData();
                }
                case BOOLEAN: {
                    return this.handleBytesConversionFailure("boolean");
                }
                case DATE_TIME: {
                    return this.handleBytesConversionFailure("date");
                }
                case DB_POINTER: {
                    return this.handleBytesConversionFailure("db_pointer");
                }
                case DECIMAL128: {
                    return this.handleBytesConversionFailure("decimal128");
                }
                case DOCUMENT: {
                    return this.handleBytesConversionFailure("document");
                }
                case DOUBLE: {
                    return this.handleBytesConversionFailure("double");
                }
                case END_OF_DOCUMENT: {
                    return this.handleBytesConversionFailure("end_of_document");
                }
                case INT32: {
                    return this.handleBytesConversionFailure("int32");
                }
                case INT64: {
                    return this.handleBytesConversionFailure("int64");
                }
                case JAVASCRIPT: {
                    return this.handleBytesConversionFailure("javascript");
                }
                case JAVASCRIPT_WITH_SCOPE: {
                    return this.handleBytesConversionFailure("javascript_with_code");
                }
                case MAX_KEY: {
                    return this.handleBytesConversionFailure("max_key");
                }
                case MIN_KEY: {
                    return this.handleBytesConversionFailure("min_key");
                }
                case NULL: {
                    return null;
                }
                case OBJECT_ID: {
                    return this.handleBytesConversionFailure("objectId");
                }
                case REGULAR_EXPRESSION: {
                    return this.handleBytesConversionFailure("regex");
                }
                case STRING: {
                    return this.handleBytesConversionFailure("string");
                }
                case SYMBOL: {
                    return this.handleBytesConversionFailure("symbol");
                }
                case TIMESTAMP: {
                    return this.handleBytesConversionFailure("timestamp");
                }
                case UNDEFINED: {
                    return null;
                }
            }
            throw new SQLException("Unknown BSON type: " + o.getBsonType() + ".");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_6);
            }
            throw exception;
        }
    }

    @Override
    protected String handleStringConversionFailure(String from) throws SQLException {
        try {
            if (this.relaxed) {
                return null;
            }
            throw new SQLException("The " + from + " type cannot be converted to string.");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_7);
            }
            throw exception;
        }
    }

    @Override
    protected String getString(BsonValue o) throws SQLException {
        try {
            if (this.checkNull(o)) {
                return null;
            }
            switch (o.getBsonType()) {
                case ARRAY: {
                    return this.handleStringConversionFailure("array");
                }
                case BINARY: {
                    return this.handleStringConversionFailure("binary");
                }
                case BOOLEAN: {
                    return o.asBoolean().getValue() ? "true" : "false";
                }
                case DATE_TIME: {
                    Date d = new Date(o.asDateTime().getValue());
                    return this.dateFormat.format(d);
                }
                case DB_POINTER: {
                    return this.handleStringConversionFailure("db_pointer");
                }
                case DECIMAL128: {
                    return o.asDecimal128().getValue().toString();
                }
                case DOCUMENT: {
                    return this.handleStringConversionFailure("document");
                }
                case DOUBLE: {
                    return Double.toString(o.asDouble().getValue());
                }
                case END_OF_DOCUMENT: {
                    return this.handleStringConversionFailure("end_of_document");
                }
                case INT32: {
                    return Integer.toString(o.asInt32().getValue());
                }
                case INT64: {
                    return Long.toString(o.asInt64().getValue());
                }
                case JAVASCRIPT: {
                    return this.handleStringConversionFailure("javascript");
                }
                case JAVASCRIPT_WITH_SCOPE: {
                    return this.handleStringConversionFailure("javascript_with_code");
                }
                case MAX_KEY: {
                    return this.handleStringConversionFailure("max_key");
                }
                case MIN_KEY: {
                    return this.handleStringConversionFailure("min_key");
                }
                case NULL: {
                    return null;
                }
                case OBJECT_ID: {
                    return o.asObjectId().getValue().toString();
                }
                case REGULAR_EXPRESSION: {
                    return this.handleStringConversionFailure("regex");
                }
                case STRING: {
                    return o.asString().getValue();
                }
                case SYMBOL: {
                    return this.handleStringConversionFailure("symbol");
                }
                case TIMESTAMP: {
                    return this.handleStringConversionFailure("timestamp");
                }
                case UNDEFINED: {
                    return null;
                }
            }
            throw new SQLException("Unknown BSON type: " + o.getBsonType() + ".");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_8);
            }
            throw exception;
        }
    }

    @Override
    protected boolean handleBooleanConversionFailure(String from) throws SQLException {
        try {
            if (this.relaxed) {
                return false;
            }
            throw new SQLException("The " + from + " type cannot be converted to boolean.");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_9);
            }
            throw exception;
        }
    }

    @Override
    protected boolean getBoolean(BsonValue o) throws SQLException {
        try {
            if (this.checkNull(o)) {
                return false;
            }
            switch (o.getBsonType()) {
                case ARRAY: {
                    return this.handleBooleanConversionFailure("array");
                }
                case BINARY: {
                    return this.handleBooleanConversionFailure("binary");
                }
                case BOOLEAN: {
                    return o.asBoolean().getValue();
                }
                case DATE_TIME: {
                    return this.handleBooleanConversionFailure("date");
                }
                case DB_POINTER: {
                    return this.handleBooleanConversionFailure("db_pointer");
                }
                case DECIMAL128: {
                    Decimal128 v = o.asDecimal128().getValue();
                    return v != Decimal128.POSITIVE_ZERO && v != Decimal128.NEGATIVE_ZERO;
                }
                case DOCUMENT: {
                    return this.handleBooleanConversionFailure("document");
                }
                case DOUBLE: {
                    return o.asDouble().getValue() != 0.0;
                }
                case END_OF_DOCUMENT: {
                    return this.handleBooleanConversionFailure("end_of_document");
                }
                case INT32: {
                    return o.asInt32().getValue() != 0;
                }
                case INT64: {
                    return o.asInt64().getValue() != 0L;
                }
                case JAVASCRIPT: {
                    return this.handleBooleanConversionFailure("javascript");
                }
                case JAVASCRIPT_WITH_SCOPE: {
                    return this.handleBooleanConversionFailure("javascript_with_code");
                }
                case MAX_KEY: {
                    return this.handleBooleanConversionFailure("max_key");
                }
                case MIN_KEY: {
                    return this.handleBooleanConversionFailure("min_key");
                }
                case NULL: {
                    return false;
                }
                case OBJECT_ID: {
                    return this.handleBooleanConversionFailure("objectId");
                }
                case REGULAR_EXPRESSION: {
                    return this.handleBooleanConversionFailure("regex");
                }
                case STRING: {
                    return true;
                }
                case SYMBOL: {
                    return this.handleBooleanConversionFailure("symbol");
                }
                case TIMESTAMP: {
                    return this.handleBooleanConversionFailure("timestamp");
                }
                case UNDEFINED: {
                    return false;
                }
            }
            throw new SQLException("Unknown BSON type: " + o.getBsonType() + ".");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_10);
            }
            throw exception;
        }
    }

    @Override
    protected long handleLongConversionFailure(String from) throws SQLException {
        try {
            if (this.relaxed) {
                return 0L;
            }
            throw new SQLException("The " + from + " type cannot be converted to integral type.");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_11);
            }
            throw exception;
        }
    }

    @Override
    protected long getLong(BsonValue o) throws SQLException {
        try {
            if (this.checkNull(o)) {
                return 0L;
            }
            switch (o.getBsonType()) {
                case ARRAY: {
                    return this.handleLongConversionFailure("array");
                }
                case BINARY: {
                    return this.handleLongConversionFailure("binary");
                }
                case BOOLEAN: {
                    return o.asBoolean().getValue() ? 1 : 0;
                }
                case DATE_TIME: {
                    return o.asDateTime().getValue();
                }
                case DB_POINTER: {
                    return this.handleLongConversionFailure("db_pointer");
                }
                case DECIMAL128: {
                    return o.asDecimal128().longValue();
                }
                case DOCUMENT: {
                    return this.handleLongConversionFailure("document");
                }
                case DOUBLE: {
                    return (long)o.asDouble().getValue();
                }
                case END_OF_DOCUMENT: {
                    return this.handleLongConversionFailure("end_of_document");
                }
                case INT32: {
                    return o.asInt32().getValue();
                }
                case INT64: {
                    return o.asInt64().getValue();
                }
                case JAVASCRIPT: {
                    return this.handleLongConversionFailure("javascript");
                }
                case JAVASCRIPT_WITH_SCOPE: {
                    return this.handleLongConversionFailure("javascript_with_code");
                }
                case MAX_KEY: {
                    return this.handleLongConversionFailure("max_key");
                }
                case MIN_KEY: {
                    return this.handleLongConversionFailure("min_key");
                }
                case NULL: {
                    return 0L;
                }
                case OBJECT_ID: {
                    return this.handleLongConversionFailure("objectId");
                }
                case REGULAR_EXPRESSION: {
                    return this.handleLongConversionFailure("regex");
                }
                case STRING: {
                    try {
                        return Long.parseLong(o.asString().getValue());
                    }
                    catch (NumberFormatException e) {
                        if (this.relaxed) {
                            return 0L;
                        }
                        throw new SQLException(e);
                    }
                }
                case SYMBOL: {
                    return this.handleLongConversionFailure("symbol");
                }
                case TIMESTAMP: {
                    return this.handleLongConversionFailure("timestamp");
                }
                case UNDEFINED: {
                    return 0L;
                }
            }
            throw new SQLException("Unknown BSON type: " + o.getBsonType() + ".");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_12);
            }
            throw exception;
        }
    }

    @Override
    protected double handleDoubleConversionFailure(String from) throws SQLException {
        try {
            if (this.relaxed) {
                return 0.0;
            }
            throw new SQLException("The " + from + " type cannot be converted to double.");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_13);
            }
            throw exception;
        }
    }

    @Override
    protected double getDouble(BsonValue o) throws SQLException {
        try {
            if (this.checkNull(o)) {
                return 0.0;
            }
            switch (o.getBsonType()) {
                case ARRAY: {
                    return this.handleDoubleConversionFailure("array");
                }
                case BINARY: {
                    return this.handleDoubleConversionFailure("binary");
                }
                case BOOLEAN: {
                    return o.asBoolean().getValue() ? 1.0 : 0.0;
                }
                case DATE_TIME: {
                    return o.asDateTime().getValue();
                }
                case DB_POINTER: {
                    return this.handleDoubleConversionFailure("db_pointer");
                }
                case DECIMAL128: {
                    return o.asDecimal128().doubleValue();
                }
                case DOCUMENT: {
                    return this.handleDoubleConversionFailure("document");
                }
                case DOUBLE: {
                    return o.asDouble().getValue();
                }
                case END_OF_DOCUMENT: {
                    return this.handleDoubleConversionFailure("end_of_document");
                }
                case INT32: {
                    return o.asInt32().getValue();
                }
                case INT64: {
                    return o.asInt64().getValue();
                }
                case JAVASCRIPT: {
                    return this.handleDoubleConversionFailure("javascript");
                }
                case JAVASCRIPT_WITH_SCOPE: {
                    return this.handleDoubleConversionFailure("javascript_with_code");
                }
                case MAX_KEY: {
                    return this.handleDoubleConversionFailure("max_key");
                }
                case MIN_KEY: {
                    return this.handleDoubleConversionFailure("min_key");
                }
                case NULL: {
                    return 0.0;
                }
                case OBJECT_ID: {
                    return this.handleDoubleConversionFailure("objectId");
                }
                case REGULAR_EXPRESSION: {
                    return this.handleDoubleConversionFailure("regex");
                }
                case STRING: {
                    try {
                        return Double.parseDouble(o.asString().getValue());
                    }
                    catch (NumberFormatException e) {
                        if (this.relaxed) {
                            return 0.0;
                        }
                        throw new SQLException(e);
                    }
                }
                case SYMBOL: {
                    return this.handleDoubleConversionFailure("symbol");
                }
                case TIMESTAMP: {
                    return this.handleDoubleConversionFailure("timestamp");
                }
                case UNDEFINED: {
                    return 0.0;
                }
            }
            throw new SQLException("Unknown BSON type: " + o.getBsonType() + ".");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_14);
            }
            throw exception;
        }
    }

    @Override
    protected BigDecimal handleBigDecimalConversionFailure(String from) throws SQLException {
        try {
            if (this.relaxed) {
                return BigDecimal.ZERO;
            }
            throw new SQLException("The " + from + " type cannot be converted to BigDecimal.");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_15);
            }
            throw exception;
        }
    }

    @Override
    protected BigDecimal getBigDecimal(BsonValue o) throws SQLException {
        try {
            if (this.checkNull(o)) {
                return BigDecimal.ZERO;
            }
            switch (o.getBsonType()) {
                case ARRAY: {
                    return this.handleBigDecimalConversionFailure("array");
                }
                case BINARY: {
                    return this.handleBigDecimalConversionFailure("binary");
                }
                case BOOLEAN: {
                    return o.asBoolean().getValue() ? BigDecimal.ONE : BigDecimal.ZERO;
                }
                case DATE_TIME: {
                    return new BigDecimal(o.asDateTime().getValue());
                }
                case DB_POINTER: {
                    return this.handleBigDecimalConversionFailure("db_pointer");
                }
                case DECIMAL128: {
                    return o.asDecimal128().decimal128Value().bigDecimalValue();
                }
                case DOCUMENT: {
                    return this.handleBigDecimalConversionFailure("document");
                }
                case DOUBLE: {
                    return new BigDecimal(o.asDouble().getValue());
                }
                case END_OF_DOCUMENT: {
                    return this.handleBigDecimalConversionFailure("end_of_document");
                }
                case INT32: {
                    return new BigDecimal(o.asInt32().getValue());
                }
                case INT64: {
                    return new BigDecimal(o.asInt64().getValue());
                }
                case JAVASCRIPT: {
                    return this.handleBigDecimalConversionFailure("javascript");
                }
                case JAVASCRIPT_WITH_SCOPE: {
                    return this.handleBigDecimalConversionFailure("javascript_with_code");
                }
                case MAX_KEY: {
                    return this.handleBigDecimalConversionFailure("max_key");
                }
                case MIN_KEY: {
                    return this.handleBigDecimalConversionFailure("min_key");
                }
                case NULL: {
                    return BigDecimal.ZERO;
                }
                case OBJECT_ID: {
                    return this.handleBigDecimalConversionFailure("objectId");
                }
                case REGULAR_EXPRESSION: {
                    return this.handleBigDecimalConversionFailure("regex");
                }
                case STRING: {
                    try {
                        return new BigDecimal(o.asString().getValue());
                    }
                    catch (ArithmeticException | NumberFormatException e) {
                        if (this.relaxed) {
                            return BigDecimal.ZERO;
                        }
                        throw new SQLException(e);
                    }
                }
                case SYMBOL: {
                    return this.handleBigDecimalConversionFailure("symbol");
                }
                case TIMESTAMP: {
                    return this.handleBigDecimalConversionFailure("timestamp");
                }
                case UNDEFINED: {
                    return BigDecimal.ZERO;
                }
            }
            throw new SQLException("Unknown BSON type: " + o.getBsonType() + ".");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_16);
            }
            throw exception;
        }
    }

    @Override
    protected java.util.Date handleUtilDateConversionFailure(String from) throws SQLException {
        try {
            if (this.relaxed) {
                return null;
            }
            throw new SQLException("The " + from + " type cannot be converted to java.util.Date");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_17);
            }
            throw exception;
        }
    }

    @Override
    protected java.util.Date getUtilDate(BsonValue o) throws SQLException {
        try {
            if (this.checkNull(o)) {
                return null;
            }
            switch (o.getBsonType()) {
                case ARRAY: {
                    return this.handleUtilDateConversionFailure("array");
                }
                case BINARY: {
                    return this.handleUtilDateConversionFailure("binary");
                }
                case BOOLEAN: {
                    return this.handleUtilDateConversionFailure("boolean");
                }
                case DATE_TIME: {
                    return new java.util.Date(o.asDateTime().getValue());
                }
                case DB_POINTER: {
                    return this.handleUtilDateConversionFailure("db_pointer");
                }
                case DECIMAL128: {
                    return new Date(o.asDecimal128().longValue());
                }
                case DOCUMENT: {
                    return this.handleUtilDateConversionFailure("document");
                }
                case DOUBLE: {
                    return new Date((long)o.asDouble().getValue());
                }
                case END_OF_DOCUMENT: {
                    return this.handleUtilDateConversionFailure("end_of_document");
                }
                case INT32: {
                    return new Date(o.asInt32().getValue());
                }
                case INT64: {
                    return new Date(o.asInt64().getValue());
                }
                case JAVASCRIPT: {
                    return this.handleUtilDateConversionFailure("javascript");
                }
                case JAVASCRIPT_WITH_SCOPE: {
                    return this.handleUtilDateConversionFailure("javascript_with_code");
                }
                case MAX_KEY: {
                    return this.handleUtilDateConversionFailure("max_key");
                }
                case MIN_KEY: {
                    return this.handleUtilDateConversionFailure("min_key");
                }
                case NULL: {
                    return null;
                }
                case OBJECT_ID: {
                    return this.handleUtilDateConversionFailure("objectId");
                }
                case REGULAR_EXPRESSION: {
                    return this.handleUtilDateConversionFailure("regex");
                }
                case STRING: {
                    try {
                        return this.dateFormat.parse(o.asString().getValue());
                    }
                    catch (ParseException e) {
                        if (this.relaxed) {
                            return null;
                        }
                        throw new SQLException(e);
                    }
                }
                case SYMBOL: {
                    return this.handleUtilDateConversionFailure("symbol");
                }
                case TIMESTAMP: {
                    return this.handleUtilDateConversionFailure("timestamp");
                }
                case UNDEFINED: {
                    return null;
                }
            }
            throw new SQLException("Unknown BSON type: " + o.getBsonType() + ".");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_18);
            }
            throw exception;
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            BsonValue out;
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            if (this.checkNull(out = this.getBsonValue(columnIndex))) {
                return null;
            }
            int columnType = this.rsMetaData.getColumnType(columnIndex);
            return this.getObject(out, columnType);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_19);
            }
            throw exception;
        }
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)string));
            }
            int columnIndex = this.findColumn(columnLabel);
            return this.getObject(columnIndex);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_20);
            }
            throw exception;
        }
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        int n = columnIndex;
        Map<String, Class<?>> map2 = map;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), map2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_21);
            }
            throw exception;
        }
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        String string = columnLabel;
        Map<String, Class<?>> map2 = map;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object)string, map2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_22);
            }
            throw exception;
        }
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        int n = columnIndex;
        Class<T> clazz = type;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), clazz));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_23);
            }
            throw exception;
        }
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        String string = columnLabel;
        Class<T> clazz = type;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object)string, clazz));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_24);
            }
            throw exception;
        }
    }

    static {
        MySQLResultSet.ajc$preClinit();
    }

    @Override
    public /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet() {
        return this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;
    }

    @Override
    public /* synthetic */ void ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectSet(LoggingAspect loggingAspect) {
        this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField = loggingAspect;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MySQLResultSet.java", MySQLResultSet.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setupResultset", "com.mongodb.jdbc.MySQLResultSet", "com.mongodb.client.MongoCursor:boolean", "cursor:relaxed", "java.sql.SQLException", "void"), 75);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "checkNull", "com.mongodb.jdbc.MySQLResultSet", "org.bson.BsonValue", "o", "", "boolean"), 87);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getBoolean", "com.mongodb.jdbc.MySQLResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "boolean"), 382);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleLongConversionFailure", "com.mongodb.jdbc.MySQLResultSet", "java.lang.String", "from", "java.sql.SQLException", "long"), 444);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getLong", "com.mongodb.jdbc.MySQLResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "long"), 450);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleDoubleConversionFailure", "com.mongodb.jdbc.MySQLResultSet", "java.lang.String", "from", "java.sql.SQLException", "double"), 512);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getDouble", "com.mongodb.jdbc.MySQLResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "double"), 518);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleBigDecimalConversionFailure", "com.mongodb.jdbc.MySQLResultSet", "java.lang.String", "from", "java.sql.SQLException", "java.math.BigDecimal"), 580);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getBigDecimal", "com.mongodb.jdbc.MySQLResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "java.math.BigDecimal"), 586);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleUtilDateConversionFailure", "com.mongodb.jdbc.MySQLResultSet", "java.lang.String", "from", "java.sql.SQLException", "java.util.Date"), 648);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getUtilDate", "com.mongodb.jdbc.MySQLResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "java.util.Date"), 654);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObject", "com.mongodb.jdbc.MySQLResultSet", "int", "columnIndex", "java.sql.SQLException", "java.lang.Object"), 714);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getBsonValue", "com.mongodb.jdbc.MySQLResultSet", "int", "columnIndex", "java.sql.SQLException", "org.bson.BsonValue"), 127);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObject", "com.mongodb.jdbc.MySQLResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.lang.Object"), 725);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObject", "com.mongodb.jdbc.MySQLResultSet", "int:java.util.Map", "columnIndex:map", "java.sql.SQLException", "java.lang.Object"), 731);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObject", "com.mongodb.jdbc.MySQLResultSet", "java.lang.String:java.util.Map", "columnLabel:map", "java.sql.SQLException", "java.lang.Object"), 738);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObject", "com.mongodb.jdbc.MySQLResultSet", "int:java.lang.Class", "columnIndex:type", "java.sql.SQLException", "java.lang.Object"), 745);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObject", "com.mongodb.jdbc.MySQLResultSet", "java.lang.String:java.lang.Class", "columnLabel:type", "java.sql.SQLException", "java.lang.Object"), 751);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getBsonValue", "com.mongodb.jdbc.MySQLResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "org.bson.BsonValue"), 133);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getObject", "com.mongodb.jdbc.MySQLResultSet", "org.bson.BsonValue:int", "o:columnType", "java.sql.SQLException", "java.lang.Object"), 138);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleBytesConversionFailure", "com.mongodb.jdbc.MySQLResultSet", "java.lang.String", "from", "java.sql.SQLException", "[B"), 248);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getBytes", "com.mongodb.jdbc.MySQLResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "[B"), 254);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleStringConversionFailure", "com.mongodb.jdbc.MySQLResultSet", "java.lang.String", "from", "java.sql.SQLException", "java.lang.String"), 313);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getString", "com.mongodb.jdbc.MySQLResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "java.lang.String"), 320);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleBooleanConversionFailure", "com.mongodb.jdbc.MySQLResultSet", "java.lang.String", "from", "java.sql.SQLException", "boolean"), 376);
    }
}

