/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.mongodb.jdbc.MongoColumnInfo;
import com.mongodb.jdbc.MongoResultSetMetaData;
import com.mongodb.jdbc.MySQLColumnInfo;
import com.mongodb.jdbc.MySQLResultDoc;
import com.mongodb.jdbc.logging.AutoLoggable;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.LoggingAspect$ajcMightHaveAspect;
import com.mongodb.jdbc.logging.MongoLogger;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

@AutoLoggable
public class MySQLResultSetMetaData
extends MongoResultSetMetaData
implements ResultSetMetaData,
LoggingAspect$ajcMightHaveAspect {
    protected List<MySQLColumnInfo> columnInfo;
    protected Map<String, Integer> columnPositions;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private transient /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;

    public MySQLResultSetMetaData(MySQLResultDoc metadataDoc, MongoLogger parentLogger, Integer statementId) throws SQLException {
        super(parentLogger, statementId);
        LoggingAspect.ajc$perObjectBind(this);
        this.columnInfo = metadataDoc.columns;
        this.columnPositions = new HashMap<String, Integer>(this.columnInfo.size());
        int i = 0;
        for (MySQLColumnInfo c : this.columnInfo) {
            c.init();
            this.columnPositions.put(c.columnAlias, i++);
        }
    }

    @Override
    public int getColumnPositionFromLabel(String label) {
        String string = label;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string));
            }
            return this.columnPositions.get(label);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    @Override
    public boolean hasColumnWithLabel(String label) {
        String string = label;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string));
            }
            return this.columnPositions.containsKey(label);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    @Override
    public MongoColumnInfo getColumnInfo(int column) throws SQLException {
        int n = column;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            this.checkBounds(column);
            return this.columnInfo.get(column - 1);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this));
            }
            return this.columnInfo.size();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_3);
            }
            throw exception;
        }
    }

    static {
        MySQLResultSetMetaData.ajc$preClinit();
    }

    @Override
    public /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet() {
        return this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;
    }

    @Override
    public /* synthetic */ void ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectSet(LoggingAspect loggingAspect) {
        this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField = loggingAspect;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MySQLResultSetMetaData.java", MySQLResultSetMetaData.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumnPositionFromLabel", "com.mongodb.jdbc.MySQLResultSetMetaData", "java.lang.String", "label", "", "int"), 46);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hasColumnWithLabel", "com.mongodb.jdbc.MySQLResultSetMetaData", "java.lang.String", "label", "", "boolean"), 50);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumnInfo", "com.mongodb.jdbc.MySQLResultSetMetaData", "int", "column", "java.sql.SQLException", "com.mongodb.jdbc.MongoColumnInfo"), 55);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumnCount", "com.mongodb.jdbc.MySQLResultSetMetaData", "", "", "java.sql.SQLException", "int"), 61);
    }
}

