/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.dsi.core.utilities.impl.future;

import com.cloudera.impala.dsi.core.utilities.future.IntervalConverter;
import com.cloudera.impala.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.cloudera.impala.dsi.core.utilities.impl.future.ConvertingJDBCDataSink;
import com.cloudera.impala.dsi.dataengine.utilities.DSIMonthSpan;
import com.cloudera.impala.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.impala.dsi.exceptions.IncorrectTypeException;
import com.cloudera.impala.support.IWarningListener;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.sql.SQLException;

public abstract class MonthSpanJDBCDataSink
extends ConvertingJDBCDataSink {
    private final int m_sqlType;
    private final int m_leadingFieldPrecision;

    public MonthSpanJDBCDataSink(IWarningListener iWarningListener, TypeMetadata typeMetadata) {
        super(iWarningListener);
        this.m_sqlType = typeMetadata.getType();
        switch (this.m_sqlType) {
            case 101: 
            case 102: 
            case 107: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected SQL type " + this.m_sqlType);
            }
        }
        this.m_leadingFieldPrecision = typeMetadata.getIntervalPrecision();
        assert (this.m_leadingFieldPrecision > 0 && this.m_leadingFieldPrecision <= 9);
    }

    @Override
    protected IntervalConverter getIntervalConverter() {
        return IntervalConverter.INSTANCE;
    }

    protected final int getSqlType() {
        return this.m_sqlType;
    }

    protected final int getLeadingFieldPrecision() {
        return this.m_leadingFieldPrecision;
    }

    protected final void handleConversionResult(Object object, String string) {
        switch (this.getListener().getStatus()) {
            case SUCCESS: {
                break;
            }
            case FRACTIONAL_TRUNCATION: {
                this.onFractionalTruncation(object, 0, string);
                break;
            }
            case OVERFLOW: {
                this.onOverflow(object, string);
            }
        }
    }

    protected abstract void doSet(DSIMonthSpan var1) throws ErrorException;

    @Override
    public void set(Object object) throws IncorrectTypeException, ErrorException {
        if (object == null) {
            this.doSet(null);
        } else if (object instanceof DSIMonthSpan) {
            DSIMonthSpan dSIMonthSpan = this.getIntervalConverter().normalize((DSIMonthSpan)object, this.m_sqlType, this.m_leadingFieldPrecision, this.getWarningListener(), this.getAndClearListener());
            this.handleConversionResult(object, "set");
            this.doSet(dSIMonthSpan);
        } else {
            throw new IncorrectTypeException();
        }
    }

    @Override
    public void setNull(int n) throws IncorrectTypeException, SQLException, ErrorException {
        switch (n) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 0: 
            case 1: 
            case 12: 
            case 101: 
            case 102: 
            case 107: 
            case 2000: {
                this.doSet(null);
                break;
            }
            default: {
                throw new IncorrectTypeException();
            }
        }
    }

    @Override
    public void setString(String string) throws IncorrectTypeException, SQLException, ErrorException {
        if (string == null) {
            this.setNull(1);
        } else {
            DSIMonthSpan dSIMonthSpan = NonTrivialJDBCConversions.stringToMonthSpan(string, this.m_sqlType, this.getIntervalConverter(), this.m_leadingFieldPrecision, this.getWarningListener(), this.getAndClearListener());
            this.handleConversionResult(string, "setString");
            this.doSet(dSIMonthSpan);
        }
    }
}

