/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.dsi.core.utilities.impl.future;

import com.cloudera.impala.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.cloudera.impala.dsi.core.utilities.impl.future.ConvertingJDBCDataSink;
import com.cloudera.impala.dsi.exceptions.IncorrectTypeException;
import com.cloudera.impala.support.IWarningListener;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.sql.SQLException;

public abstract class NumberJDBCDataSink<T extends Number>
extends ConvertingJDBCDataSink {
    protected abstract void doSet(T var1) throws ErrorException;

    public NumberJDBCDataSink(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    protected final void handleConversionResult(Object object, String string) {
        switch (this.getListener().getStatus()) {
            case SUCCESS: {
                break;
            }
            case FRACTIONAL_TRUNCATION: {
                this.onFractionalTruncation(object, 0, string);
                break;
            }
            case OVERFLOW: {
                this.onOverflow(object, string);
            }
        }
    }

    protected final boolean conversionSuccessful() {
        return NonTrivialJDBCConversions.ConversionStatus.SUCCESS == this.getListener().getStatus();
    }

    protected boolean isSupportedSourceType(int n) {
        switch (n) {
            case -10: 
            case -9: 
            case -8: 
            case -7: 
            case -6: 
            case -5: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 2000: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setNull(int n) throws IncorrectTypeException, SQLException, ErrorException {
        if (!this.isSupportedSourceType(n)) {
            throw new IncorrectTypeException();
        }
        this.doSet(null);
    }

    @Override
    public void setBoolean(boolean bl) throws IncorrectTypeException, SQLException, ErrorException {
        this.setByte((byte)(bl ? 1 : 0));
    }
}

