/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.api;

import com.cloudera.impala.dsi.core.impl.DSIDriverSingleton;
import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.api.HS2ClientWrapper;
import com.cloudera.impala.hivecommon.api.SSOSAMLTHttpClient;
import com.cloudera.impala.hivecommon.api.TETHttpClient;
import com.cloudera.impala.hivecommon.api.WebBrowserClient;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.hivecommon.exceptions.TEHttpRetryException;
import com.cloudera.impala.hivecommon.exceptions.TEHttpSSORedirectException;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCancelDelegationTokenReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCancelDelegationTokenResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseImpalaOperationReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseImpalaOperationResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseOperationReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseOperationResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseSessionReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseSessionResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TExecuteStatementReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TExecuteStatementResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TFetchResultsReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TFetchResultsResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetCatalogsReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetCatalogsResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetColumnsReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetColumnsResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetDelegationTokenReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetDelegationTokenResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetFunctionsReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetFunctionsResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetInfoReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetInfoResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetOperationStatusReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetOperationStatusResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetResultSetMetadataReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetResultSetMetadataResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetSchemasReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetSchemasResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTableTypesReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTableTypesResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTablesReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTablesResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTypeInfoReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTypeInfoResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TOpenSessionReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TOpenSessionResp;
import com.cloudera.impala.jdbc42.internal.apache.thrift.TException;
import com.cloudera.impala.jdbc42.internal.apache.thrift.protocol.TProtocol;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TTransportException;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.net.URI;
import java.net.URISyntaxException;

public class HS2SSOSAMLClientWrapper
extends HS2ClientWrapper {
    public static final String AUTHORIZATION_KEY = "Authorization";
    public static final String BEARER = "Bearer ";
    public static final String COOKIE_HEADER_HIVE = "hive.server2.auth";
    public static final String COOKIE_HEADER_IMPALA = "impala.auth";
    public static final String TOKEN_TYPE_BEARER = "Bearer ";
    public static final String SSO_DEV_TOKEN_RESPONSE_PORT = "X-Token-Response-Port";
    public static final String SSO_TOKEN_RESPONSE_PORT = "X-Hive-Token-Response-Port";
    private static final int MILLIS_PER_NANO = 1000000;
    private ILogger m_logger;
    private HiveJDBCSettings m_settings;
    private WebBrowserClient m_browserClient = null;
    private String m_clientIdentifier;
    private boolean m_authOnNextCall = true;
    private int m_authTryConsecutiveCount = 0;
    private boolean m_isFirstAuthCall = true;

    public HS2SSOSAMLClientWrapper(TProtocol tProtocol, ILogger iLogger, HiveJDBCSettings hiveJDBCSettings) throws ErrorException {
        super(tProtocol, iLogger, hiveJDBCSettings.m_thriftHTTPSettings);
        LogUtilities.logFunctionEntrance(iLogger, tProtocol, iLogger, hiveJDBCSettings);
        this.m_logger = iLogger;
        this.m_settings = hiveJDBCSettings;
        this.m_browserClient = new WebBrowserClient(hiveJDBCSettings.m_ssoSamlSettings, this.m_logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TCancelDelegationTokenResp CancelDelegationToken(TCancelDelegationTokenReq tCancelDelegationTokenReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tCancelDelegationTokenReq);
        HS2SSOSAMLClientWrapper hS2SSOSAMLClientWrapper = this;
        synchronized (hS2SSOSAMLClientWrapper) {
            if (this.m_authOnNextCall) {
                this.doAuthentication();
            }
            this.updateHeaders();
            return super.CancelDelegationToken(tCancelDelegationTokenReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TCloseImpalaOperationResp CloseImpalaOperation(TCloseImpalaOperationReq tCloseImpalaOperationReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tCloseImpalaOperationReq);
        HS2SSOSAMLClientWrapper hS2SSOSAMLClientWrapper = this;
        synchronized (hS2SSOSAMLClientWrapper) {
            if (this.m_authOnNextCall) {
                this.doAuthentication();
            }
            this.updateHeaders();
            return super.CloseImpalaOperation(tCloseImpalaOperationReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TCloseOperationResp CloseOperation(TCloseOperationReq tCloseOperationReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tCloseOperationReq);
        HS2SSOSAMLClientWrapper hS2SSOSAMLClientWrapper = this;
        synchronized (hS2SSOSAMLClientWrapper) {
            if (this.m_authOnNextCall) {
                this.doAuthentication();
            }
            this.updateHeaders();
            return super.CloseOperation(tCloseOperationReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TCloseSessionResp CloseSession(TCloseSessionReq tCloseSessionReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tCloseSessionReq);
        HS2SSOSAMLClientWrapper hS2SSOSAMLClientWrapper = this;
        synchronized (hS2SSOSAMLClientWrapper) {
            if (this.m_authOnNextCall) {
                this.doAuthentication();
            }
            this.updateHeaders();
            return super.CloseSession(tCloseSessionReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TExecuteStatementResp ExecuteStatement(TExecuteStatementReq tExecuteStatementReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tExecuteStatementReq);
        HS2SSOSAMLClientWrapper hS2SSOSAMLClientWrapper = this;
        synchronized (hS2SSOSAMLClientWrapper) {
            if (this.m_authOnNextCall) {
                this.doAuthentication();
            }
            this.updateHeaders();
            return super.ExecuteStatement(tExecuteStatementReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TFetchResultsResp FetchResults(TFetchResultsReq tFetchResultsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tFetchResultsReq);
        HS2SSOSAMLClientWrapper hS2SSOSAMLClientWrapper = this;
        synchronized (hS2SSOSAMLClientWrapper) {
            if (this.m_authOnNextCall) {
                this.doAuthentication();
            }
            this.updateHeaders();
            return super.FetchResults(tFetchResultsReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetCatalogsResp GetCatalogs(TGetCatalogsReq tGetCatalogsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetCatalogsReq);
        HS2SSOSAMLClientWrapper hS2SSOSAMLClientWrapper = this;
        synchronized (hS2SSOSAMLClientWrapper) {
            if (this.m_authOnNextCall) {
                this.doAuthentication();
            }
            this.updateHeaders();
            return super.GetCatalogs(tGetCatalogsReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetColumnsResp GetColumns(TGetColumnsReq tGetColumnsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetColumnsReq);
        HS2SSOSAMLClientWrapper hS2SSOSAMLClientWrapper = this;
        synchronized (hS2SSOSAMLClientWrapper) {
            if (this.m_authOnNextCall) {
                this.doAuthentication();
            }
            this.updateHeaders();
            return super.GetColumns(tGetColumnsReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetDelegationTokenResp GetDelegationToken(TGetDelegationTokenReq tGetDelegationTokenReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetDelegationTokenReq);
        HS2SSOSAMLClientWrapper hS2SSOSAMLClientWrapper = this;
        synchronized (hS2SSOSAMLClientWrapper) {
            if (this.m_authOnNextCall) {
                this.doAuthentication();
            }
            this.updateHeaders();
            return super.GetDelegationToken(tGetDelegationTokenReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetFunctionsResp GetFunctions(TGetFunctionsReq tGetFunctionsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetFunctionsReq);
        HS2SSOSAMLClientWrapper hS2SSOSAMLClientWrapper = this;
        synchronized (hS2SSOSAMLClientWrapper) {
            if (this.m_authOnNextCall) {
                this.doAuthentication();
            }
            this.updateHeaders();
            return super.GetFunctions(tGetFunctionsReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetInfoResp GetInfo(TGetInfoReq tGetInfoReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetInfoReq);
        HS2SSOSAMLClientWrapper hS2SSOSAMLClientWrapper = this;
        synchronized (hS2SSOSAMLClientWrapper) {
            if (this.m_authOnNextCall) {
                this.doAuthentication();
            }
            this.updateHeaders();
            return super.GetInfo(tGetInfoReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetOperationStatusResp GetOperationStatus(TGetOperationStatusReq tGetOperationStatusReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetOperationStatusReq);
        HS2SSOSAMLClientWrapper hS2SSOSAMLClientWrapper = this;
        synchronized (hS2SSOSAMLClientWrapper) {
            if (this.m_authOnNextCall) {
                this.doAuthentication();
            }
            this.updateHeaders();
            return super.GetOperationStatus(tGetOperationStatusReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetResultSetMetadataResp GetResultSetMetadata(TGetResultSetMetadataReq tGetResultSetMetadataReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetResultSetMetadataReq);
        HS2SSOSAMLClientWrapper hS2SSOSAMLClientWrapper = this;
        synchronized (hS2SSOSAMLClientWrapper) {
            if (this.m_authOnNextCall) {
                this.doAuthentication();
            }
            this.updateHeaders();
            return super.GetResultSetMetadata(tGetResultSetMetadataReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetSchemasResp GetSchemas(TGetSchemasReq tGetSchemasReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetSchemasReq);
        HS2SSOSAMLClientWrapper hS2SSOSAMLClientWrapper = this;
        synchronized (hS2SSOSAMLClientWrapper) {
            if (this.m_authOnNextCall) {
                this.doAuthentication();
            }
            this.updateHeaders();
            return super.GetSchemas(tGetSchemasReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetTableTypesResp GetTableTypes(TGetTableTypesReq tGetTableTypesReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetTableTypesReq);
        HS2SSOSAMLClientWrapper hS2SSOSAMLClientWrapper = this;
        synchronized (hS2SSOSAMLClientWrapper) {
            if (this.m_authOnNextCall) {
                this.doAuthentication();
            }
            this.updateHeaders();
            return super.GetTableTypes(tGetTableTypesReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetTablesResp GetTables(TGetTablesReq tGetTablesReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetTablesReq);
        HS2SSOSAMLClientWrapper hS2SSOSAMLClientWrapper = this;
        synchronized (hS2SSOSAMLClientWrapper) {
            if (this.m_authOnNextCall) {
                this.doAuthentication();
            }
            this.updateHeaders();
            return super.GetTables(tGetTablesReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetTypeInfoResp GetTypeInfo(TGetTypeInfoReq tGetTypeInfoReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetTypeInfoReq);
        HS2SSOSAMLClientWrapper hS2SSOSAMLClientWrapper = this;
        synchronized (hS2SSOSAMLClientWrapper) {
            if (this.m_authOnNextCall) {
                this.doAuthentication();
            }
            this.updateHeaders();
            return super.GetTypeInfo(tGetTypeInfoReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TOpenSessionResp OpenSession(TOpenSessionReq tOpenSessionReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tOpenSessionReq);
        HS2SSOSAMLClientWrapper hS2SSOSAMLClientWrapper = this;
        synchronized (hS2SSOSAMLClientWrapper) {
            if (this.m_authOnNextCall) {
                this.doAuthentication();
            }
            this.updateHeaders();
            return super.OpenSession(tOpenSessionReq);
        }
    }

    @Override
    protected boolean shouldReexecuteRequest(TEHttpRetryException tEHttpRetryException) throws TException {
        if (null == tEHttpRetryException || null == this.m_teHttpSettings) {
            return false;
        }
        boolean bl = super.shouldReexecuteRequest(tEHttpRetryException);
        if (401 == tEHttpRetryException.errorCode) {
            if (bl) {
                LogUtilities.logDebug("Retrying authentication due to 401 received.", this.m_logger);
                this.doAuthentication();
            } else {
                this.m_authOnNextCall = true;
                throw tEHttpRetryException;
            }
        }
        return bl;
    }

    private void doAuthentication() throws TException {
        ++this.m_authTryConsecutiveCount;
        if (this.m_authTryConsecutiveCount > this.m_settings.m_ssoSamlSettings.m_ssoMaxConsecutiveAuthTries && 0 != this.m_settings.m_ssoSamlSettings.m_ssoMaxConsecutiveAuthTries) {
            throw new TTransportException("Maximum number of consecutive authentication tries exceeded.");
        }
        this.setTokenHeaders(null);
        TOpenSessionReq tOpenSessionReq = new TOpenSessionReq();
        long l = System.nanoTime();
        try {
            super.OpenSession(tOpenSessionReq);
        }
        catch (TEHttpSSORedirectException tEHttpSSORedirectException) {
            long l2 = (System.nanoTime() - l) / 1000000L;
            if (!this.setBrowserTimeout(l2)) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SSO_RESPONSE_TIMEOUT.name());
                errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
                throw new TTransportException(errorException);
            }
            this.doBrowserAuthWorkflow(tEHttpSSORedirectException);
            this.m_authTryConsecutiveCount = 0;
            this.m_authOnNextCall = false;
            this.m_isFirstAuthCall = false;
        }
    }

    private void doBrowserAuthWorkflow(TEHttpSSORedirectException tEHttpSSORedirectException) throws TTransportException {
        String string = null;
        try {
            this.parseSSORedirectException(tEHttpSSORedirectException);
            this.m_browserClient.doBrowserSSO();
            if (!this.m_browserClient.isSuccess()) {
                if (this.m_browserClient.hasResponse()) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SSO_BROWSER_AUTH_FAILED_WITH_MSG.name(), this.m_browserClient.getMessage());
                    throw errorException;
                }
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SSO_RESPONSE_TIMEOUT.name());
                throw errorException;
            }
            string = this.getToken();
            LogUtilities.logDebug("Token retrieved from web client.", this.m_logger);
            this.setTokenHeaders(string);
        }
        catch (ErrorException errorException) {
            try {
                errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
                throw new TTransportException(errorException);
            }
            catch (Throwable throwable) {
                this.setTokenHeaders(string);
                throw throwable;
            }
        }
    }

    private int getPort() {
        return this.m_browserClient.getPort();
    }

    private void parseSSORedirectException(TEHttpSSORedirectException tEHttpSSORedirectException) throws ErrorException {
        this.m_clientIdentifier = tEHttpSSORedirectException.m_clientId;
        try {
            this.m_browserClient.setSSOUri(new URI(tEHttpSSORedirectException.m_uri));
        }
        catch (URISyntaxException uRISyntaxException) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SSO_INVALID_URL_RECEIVED.name());
            throw errorException;
        }
    }

    private String getClientIdentifierHeader() {
        return SSOSAMLTHttpClient.getClientIdentifierHeaderKey(this.m_settings.m_ssoSamlSettings);
    }

    private String getToken() {
        return this.m_browserClient.getToken();
    }

    private String getTokenResponsePortHeader() {
        return this.m_settings.m_ssoSamlSettings.m_ssoTestingUseDevHeaders ? SSO_DEV_TOKEN_RESPONSE_PORT : SSO_TOKEN_RESPONSE_PORT;
    }

    private boolean setBrowserTimeout(long l) {
        int n;
        int n2 = n = this.m_settings.m_ssoSamlSettings.m_ssoBrowserTimeoutPrecedence ? this.m_settings.m_ssoSamlSettings.m_ssoBrowserTimeout : this.m_settings.m_timeout;
        if (n != 0 && this.m_isFirstAuthCall && !this.m_settings.m_ssoSamlSettings.m_ssoBrowserTimeoutPrecedence) {
            if (l > (long)n) {
                return false;
            }
            n = (int)((long)n - l);
        }
        this.m_browserClient.setTimeout(n);
        return true;
    }

    private void setTokenHeaders(String string) {
        if (this.getOutputProtocol().getTransport() instanceof TETHttpClient) {
            TETHttpClient tETHttpClient = (TETHttpClient)this.getOutputProtocol().getTransport();
            if (string != null && !string.isEmpty()) {
                LogUtilities.logTrace("Setting authorization token in header.", this.m_logger);
                if (this.m_settings.m_ssoSamlSettings.m_ssoLogSensitiveInfoForDebug) {
                    LogUtilities.logTrace("Setting token: " + string, this.m_logger);
                }
                tETHttpClient.setCustomHeader(AUTHORIZATION_KEY, "Bearer " + string);
                tETHttpClient.setCustomHeader(this.getClientIdentifierHeader(), this.m_clientIdentifier);
                tETHttpClient.removeCustomHeader(this.getTokenResponsePortHeader());
                tETHttpClient.removeCookie(COOKIE_HEADER_HIVE);
                tETHttpClient.removeCookie(COOKIE_HEADER_IMPALA);
            } else {
                LogUtilities.logTrace("Setting token response in header.", this.m_logger);
                tETHttpClient.removeCustomHeader(AUTHORIZATION_KEY);
                tETHttpClient.removeCustomHeader(this.getClientIdentifierHeader());
                tETHttpClient.setCustomHeader(this.getTokenResponsePortHeader(), String.valueOf(this.getPort()));
            }
        }
    }

    private void updateHeaders() {
        TETHttpClient tETHttpClient;
        if (this.getOutputProtocol().getTransport() instanceof TETHttpClient && (null != (tETHttpClient = (TETHttpClient)this.getOutputProtocol().getTransport()).getCookie(COOKIE_HEADER_HIVE) || null != tETHttpClient.getCookie(COOKIE_HEADER_IMPALA))) {
            LogUtilities.logDebug("Removing unnecessary token headers since a cookie was acquired.", this.m_logger);
            tETHttpClient.removeCustomHeader(AUTHORIZATION_KEY);
            tETHttpClient.removeCustomHeader(this.getClientIdentifierHeader());
        }
    }
}

