/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.api;

import com.cloudera.impala.hivecommon.api.SSOSAMLSettings;
import com.cloudera.impala.hivecommon.api.TEHTTPSettings;
import com.cloudera.impala.hivecommon.api.TETHttpClient;
import com.cloudera.impala.hivecommon.exceptions.TEHttpSSORedirectException;
import com.cloudera.impala.jdbc42.internal.apache.http.HttpResponse;
import com.cloudera.impala.jdbc42.internal.apache.http.client.CookieStore;
import com.cloudera.impala.jdbc42.internal.apache.http.client.HttpClient;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TTransportException;
import com.cloudera.impala.support.ILogger;

public class SSOSAMLTHttpClient
extends TETHttpClient {
    public static final String SSO_CLIENT_IDENTIFIER = "X-Hive-Client-Identifier";
    public static final String SSO_DEV_CLIENT_IDENTIFIER = "X-Client-Identifier";
    private SSOSAMLSettings m_ssoSettings;

    public SSOSAMLTHttpClient(String string, HttpClient httpClient, TEHTTPSettings tEHTTPSettings, SSOSAMLSettings sSOSAMLSettings, CookieStore cookieStore, ILogger iLogger) throws TTransportException {
        super(string, httpClient, tEHTTPSettings, cookieStore, iLogger);
        this.m_ssoSettings = sSOSAMLSettings;
    }

    public static String getClientIdentifierHeaderKey(SSOSAMLSettings sSOSAMLSettings) {
        return sSOSAMLSettings.m_ssoTestingUseDevHeaders ? SSO_DEV_CLIENT_IDENTIFIER : SSO_CLIENT_IDENTIFIER;
    }

    @Override
    protected void handleErrorResponse(HttpResponse httpResponse) throws TTransportException {
        int n = httpResponse.getStatusLine().getStatusCode();
        if (this.m_settings.m_throwDifferentExceptionOnRedirect && 302 == n) {
            throw new TEHttpSSORedirectException(httpResponse, this.extractThriftHeaderError(httpResponse), SSOSAMLTHttpClient.getClientIdentifierHeaderKey(this.m_ssoSettings));
        }
        super.handleErrorResponse(httpResponse);
    }
}

