/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.api;

import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.api.DelegationToken;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;

public class SaslCallbackHandler
implements CallbackHandler {
    private HiveJDBCSettings m_settings;
    private String m_tokenUsername = null;
    private char[] m_tokenPassword = null;

    public SaslCallbackHandler(HiveJDBCSettings hiveJDBCSettings) {
        this.m_settings = hiveJDBCSettings;
    }

    public SaslCallbackHandler(DelegationToken delegationToken) {
        if (null != delegationToken) {
            this.m_tokenUsername = delegationToken.getIdentifier();
            this.m_tokenPassword = delegationToken.getPassword();
        }
    }

    @Override
    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbackArray) {
            if (callback instanceof NameCallback) {
                if (this.m_tokenUsername != null) {
                    ((NameCallback)callback).setName(this.m_tokenUsername);
                    continue;
                }
                if (this.m_settings.m_username != null) {
                    ((NameCallback)callback).setName(this.m_settings.m_username);
                    continue;
                }
                ((NameCallback)callback).setName("anonymous");
                continue;
            }
            if (callback instanceof PasswordCallback) {
                if (this.m_tokenPassword != null) {
                    ((PasswordCallback)callback).setPassword(this.m_tokenPassword);
                    continue;
                }
                if (this.m_settings.m_password != null) {
                    ((PasswordCallback)callback).setPassword(this.m_settings.m_password.toCharArray());
                    continue;
                }
                ((PasswordCallback)callback).setPassword("anonymous".toCharArray());
                continue;
            }
            if (callback instanceof RealmCallback && null == this.m_settings) {
                RealmCallback realmCallback = (RealmCallback)callback;
                realmCallback.setText(realmCallback.getDefaultText());
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }
}

