/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.api;

import com.cloudera.impala.hivecommon.api.SSOSAMLSettings;
import com.cloudera.impala.hivecommon.api.WebConnection;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;

public class WebServer
implements Runnable {
    private AtomicBoolean m_continueFlag;
    private ExecutorService m_executorService;
    private ILogger m_logger;
    private ServerSocket m_serverSocket;
    private SSOSAMLSettings m_settings;
    private WebConnection.SetValueFunction m_setValueFunction;

    public WebServer(ServerSocket serverSocket, ExecutorService executorService, WebConnection.SetValueFunction setValueFunction, AtomicBoolean atomicBoolean, ILogger iLogger, SSOSAMLSettings sSOSAMLSettings) {
        this.m_setValueFunction = setValueFunction;
        this.m_executorService = executorService;
        this.m_continueFlag = atomicBoolean;
        this.m_serverSocket = serverSocket;
        this.m_logger = iLogger;
        this.m_settings = sSOSAMLSettings;
    }

    @Override
    public void run() {
        LogUtilities.logDebug("Start listening for browser connections.", this.m_logger);
        while (this.m_continueFlag.get()) {
            try {
                Socket socket = this.m_serverSocket.accept();
                this.m_executorService.submit(new WebConnection(socket, this.m_setValueFunction, this.m_logger, this.m_settings));
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (IOException iOException) {
                LogUtilities.logDebug("IO exception while connecting to .", this.m_logger);
            }
        }
        LogUtilities.logDebug("Server response found, not listening for new connections.", this.m_logger);
    }
}

