/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc.common.future;

import com.cloudera.impala.dsi.core.utilities.impl.future.NullJDBCDataSource;
import com.cloudera.impala.dsi.core.utilities.impl.future.SignedIntJDBCDataSource;
import com.cloudera.impala.dsi.dataengine.interfaces.future.IJDBCDataSource;
import com.cloudera.impala.dsi.dataengine.interfaces.future.IResultSet;
import com.cloudera.impala.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.impala.dsi.dataengine.utilities.MetadataSourceID;
import com.cloudera.impala.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.impala.dsi.exceptions.IncorrectTypeException;
import com.cloudera.impala.exceptions.ExceptionConverter;
import com.cloudera.impala.exceptions.JDBCMessageKey;
import com.cloudera.impala.jdbc.common.future.SDatabaseMetaData;
import com.cloudera.impala.jdbc.common.future.SForwardResultSet;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.IWarningListener;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.exceptions.ErrorException;
import com.cloudera.impala.support.exceptions.ExceptionType;
import com.cloudera.impala.utilities.JDBCVersion;
import com.cloudera.impala.utilities.MetaDataFactory;
import java.sql.SQLException;
import java.util.List;

public abstract class SMetaDataProxy
extends SForwardResultSet {
    private final boolean[] m_validColumns;
    private final IJDBCDataSource[] m_dataSources;
    private final MetadataSourceID m_metadataType;

    protected SMetaDataProxy(SDatabaseMetaData sDatabaseMetaData, IResultSet iResultSet, MetadataSourceID metadataSourceID, ILogger iLogger, JDBCVersion jDBCVersion) throws SQLException {
        super(sDatabaseMetaData, iResultSet, iLogger);
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{sDatabaseMetaData, iResultSet, metadataSourceID, iLogger, jDBCVersion});
        this.m_metadataType = metadataSourceID;
        this.m_jdbcVersion = jDBCVersion;
        int[] nArray = this.getColumnMap(this.m_metadataType);
        this.m_dataSources = this.initDataSources(nArray);
        this.m_validColumns = SMetaDataProxy.initValidColumns(nArray);
        this.initializeColumnNameMap();
    }

    private static int getMaxValue(int[] nArray) {
        int n = Integer.MIN_VALUE;
        for (int n2 : nArray) {
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private static boolean[] initValidColumns(int[] nArray) {
        boolean[] blArray = new boolean[SMetaDataProxy.getMaxValue(nArray)];
        for (int n : nArray) {
            assert (n > 0);
            assert (!blArray[n - 1]);
            blArray[n - 1] = true;
        }
        return blArray;
    }

    private IJDBCDataSource[] initDataSources(int[] nArray) throws SQLException {
        int n = SMetaDataProxy.getDataTypeColIndex(this.m_metadataType);
        IJDBCDataSource[] iJDBCDataSourceArray = new IJDBCDataSource[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            iJDBCDataSourceArray[i] = this.shouldReturnNull(i + 1) ? NullJDBCDataSource.INSTANCE : (nArray[i] == n ? new DataTypeMappingSource(super.getDataSource(nArray[i]), this.m_warningListener) : super.getDataSource(nArray[i]));
        }
        return iJDBCDataSourceArray;
    }

    private boolean shouldReturnNull(int n) {
        switch (this.m_metadataType) {
            case COLUMNS: {
                return 18 < n && 23 > n;
            }
            case TABLES: {
                return 5 < n && 11 > n;
            }
            case ATTRIBUTES: 
            case SUPERTABLES: 
            case SUPERTYPES: 
            case UDT: {
                return true;
            }
        }
        return false;
    }

    private static int getDataTypeColIndex(MetadataSourceID metadataSourceID) {
        switch (metadataSourceID) {
            case COLUMNS: 
            case ATTRIBUTES: 
            case UDT: {
                return 5;
            }
            case SPECIAL_COLUMNS: {
                return 3;
            }
            case PROCEDURE_COLUMNS: {
                return 6;
            }
            case TYPE_INFO: {
                return 2;
            }
        }
        return -1;
    }

    private int[] getColumnMap(MetadataSourceID metadataSourceID) throws SQLException {
        int n;
        int[] nArray;
        switch (metadataSourceID) {
            case CATALOG_ONLY: {
                return new int[]{1};
            }
            case SCHEMA_ONLY: 
            case CATALOG_SCHEMA_ONLY: {
                return new int[]{2, 1};
            }
            case TABLETYPE_ONLY: {
                return new int[]{4};
            }
            case COLUMN_PRIVILEGES: {
                nArray = new int[8];
                break;
            }
            case COLUMNS: {
                if (JDBCVersion.JDBC4 == this.m_jdbcVersion) {
                    nArray = new int[23];
                    break;
                }
                nArray = new int[24];
                break;
            }
            case FOREIGN_KEYS: {
                nArray = new int[14];
                break;
            }
            case FUNCTION_COLUMNS_JDBC4: {
                nArray = new int[17];
                break;
            }
            case PSEUDO_COLUMNS_JDBC41: {
                if (JDBCVersion.JDBC41 == this.m_jdbcVersion || JDBCVersion.JDBC42 == this.m_jdbcVersion) {
                    nArray = new int[12];
                    break;
                }
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NULL_METADATA_COLUMNMAP, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            case FUNCTIONS_JDBC4: {
                nArray = new int[6];
                break;
            }
            case STATISTICS: {
                nArray = new int[13];
                break;
            }
            case PRIMARY_KEYS: {
                nArray = new int[6];
                break;
            }
            case PROCEDURE_COLUMNS: {
                nArray = new int[20];
                break;
            }
            case PROCEDURES: {
                nArray = new int[9];
                break;
            }
            case SPECIAL_COLUMNS: {
                nArray = new int[8];
                break;
            }
            case SUPERTABLES: {
                nArray = new int[4];
                break;
            }
            case SUPERTYPES: {
                nArray = new int[6];
                break;
            }
            case TABLE_PRIVILEGES: {
                nArray = new int[7];
                break;
            }
            case TABLES: {
                nArray = new int[10];
                break;
            }
            case TYPE_INFO: {
                nArray = new int[18];
                break;
            }
            case UDT: {
                nArray = new int[7];
                break;
            }
            case ATTRIBUTES: {
                nArray = new int[21];
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected metadata type: " + (Object)((Object)metadataSourceID));
            }
        }
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = n + 1;
        }
        if (MetadataSourceID.COLUMNS == this.m_metadataType) {
            for (n = 18; n < 22; ++n) {
                nArray[n] = n + 2;
            }
            nArray[22] = 19;
            if (JDBCVersion.JDBC41 == this.m_jdbcVersion || JDBCVersion.JDBC42 == this.m_jdbcVersion) {
                nArray[23] = 21;
            }
        }
        return nArray;
    }

    protected List<ColumnMetadata> generateMetadataList() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        switch (this.m_metadataType) {
            case ATTRIBUTES: {
                return MetaDataFactory.createAttributeMetaData();
            }
            case CATALOG_ONLY: {
                return MetaDataFactory.createCatalogOnlyMetaData();
            }
            case COLUMN_PRIVILEGES: {
                return MetaDataFactory.createColumnPrivilegesMetaData();
            }
            case COLUMNS: {
                return MetaDataFactory.createColumnsMetaData(this.m_jdbcVersion);
            }
            case FOREIGN_KEYS: {
                return MetaDataFactory.createForeignKeysMetaData();
            }
            case FUNCTION_COLUMNS_JDBC4: {
                return MetaDataFactory.createFunctionColumnsMetaData();
            }
            case FUNCTIONS_JDBC4: {
                return MetaDataFactory.createFunctionsMetaData();
            }
            case STATISTICS: {
                return MetaDataFactory.createIndexInfoMetaData();
            }
            case PRIMARY_KEYS: {
                return MetaDataFactory.createPrimaryKeysMetaData();
            }
            case PROCEDURE_COLUMNS: {
                return MetaDataFactory.createProcedureColumnsMetaData(this.m_jdbcVersion);
            }
            case PROCEDURES: {
                return MetaDataFactory.createProceduresMetaData(this.m_jdbcVersion);
            }
            case PSEUDO_COLUMNS_JDBC41: {
                if (JDBCVersion.JDBC4 == this.m_jdbcVersion) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNKNOWN_METADATA_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf((Object)this.m_metadataType));
                }
                return MetaDataFactory.createPseudoColumnsMetaData();
            }
            case SCHEMA_ONLY: 
            case CATALOG_SCHEMA_ONLY: {
                return MetaDataFactory.createSchemasOnlyMetaData();
            }
            case SPECIAL_COLUMNS: {
                return MetaDataFactory.createSpecialColumnsMetaData();
            }
            case SUPERTABLES: {
                return MetaDataFactory.createSuperTablesMetaData();
            }
            case SUPERTYPES: {
                return MetaDataFactory.createSuperTypesMetaData();
            }
            case TABLE_PRIVILEGES: {
                return MetaDataFactory.createTablePrivilegesMetaData();
            }
            case TABLETYPE_ONLY: {
                return MetaDataFactory.createTableTypesMetaData();
            }
            case TABLES: {
                return MetaDataFactory.createTablesMetaData();
            }
            case TYPE_INFO: {
                return MetaDataFactory.createTypeInfoMetaData();
            }
            case UDT: {
                return MetaDataFactory.createUDTMetaData();
            }
        }
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNKNOWN_METADATA_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf((Object)this.m_metadataType));
    }

    @Override
    protected IJDBCDataSource getDataSource(int n) {
        return this.m_dataSources[n];
    }

    @Override
    protected void checkIfValidColumnNumber(int n) throws SQLException {
        if (n <= 0 || n >= this.m_validColumns.length || !this.m_validColumns[n - 1]) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_INDEX, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(n));
        }
    }

    @Override
    protected void initializeResultSetColumns() throws ErrorException, SQLException {
        this.m_resultSetColumns = this.generateMetadataList();
    }

    private static class DataTypeMappingSource
    extends SignedIntJDBCDataSource {
        private final IJDBCDataSource m_wrapped;

        public DataTypeMappingSource(IJDBCDataSource iJDBCDataSource, IWarningListener iWarningListener) {
            super(iWarningListener);
            this.m_wrapped = iJDBCDataSource;
        }

        @Override
        public int getInt() throws ErrorException, SQLException {
            try {
                int n = this.m_wrapped.getInt();
                if (n == 0 && this.m_wrapped.wasNull()) {
                    this.setWasNull(true);
                    return 0;
                }
                this.setWasNull(false);
                return TypeUtilities.mapDataTypes(n);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw new RuntimeException(incorrectTypeException);
            }
        }
    }
}

