/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc.http.extention;

import com.cloudera.impala.jdbc.http.extention.ExtentedSSLConnectionSocketFactory;
import com.cloudera.impala.jdbc42.internal.apache.http.protocol.HttpContext;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public class SocksSSLConnectionSocketFactory
extends ExtentedSSLConnectionSocketFactory {
    private ILogger m_logger;

    public SocksSSLConnectionSocketFactory(SSLContext sSLContext, ILogger iLogger) {
        super(sSLContext, iLogger);
        LogUtilities.logFunctionEntrance(iLogger, sSLContext);
        this.m_logger = iLogger;
    }

    public SocksSSLConnectionSocketFactory(SSLContext sSLContext, HostnameVerifier hostnameVerifier, ILogger iLogger) {
        super(sSLContext, hostnameVerifier, iLogger);
        LogUtilities.logFunctionEntrance(iLogger, sSLContext);
        this.m_logger = iLogger;
    }

    @Override
    public Socket createSocket(HttpContext httpContext) throws IOException {
        LogUtilities.logFunctionEntrance(this.m_logger, httpContext);
        InetSocketAddress inetSocketAddress = (InetSocketAddress)httpContext.getAttribute("socks.address");
        Proxy proxy = new Proxy(Proxy.Type.SOCKS, inetSocketAddress);
        return new Socket(proxy);
    }
}

