/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.apache.http.impl.conn;

import com.cloudera.impala.jdbc42.internal.apache.http.HttpResponse;
import com.cloudera.impala.jdbc42.internal.apache.http.HttpResponseFactory;
import com.cloudera.impala.jdbc42.internal.apache.http.annotation.Contract;
import com.cloudera.impala.jdbc42.internal.apache.http.annotation.ThreadingBehavior;
import com.cloudera.impala.jdbc42.internal.apache.http.config.MessageConstraints;
import com.cloudera.impala.jdbc42.internal.apache.http.impl.DefaultHttpResponseFactory;
import com.cloudera.impala.jdbc42.internal.apache.http.impl.conn.DefaultHttpResponseParser;
import com.cloudera.impala.jdbc42.internal.apache.http.io.HttpMessageParser;
import com.cloudera.impala.jdbc42.internal.apache.http.io.HttpMessageParserFactory;
import com.cloudera.impala.jdbc42.internal.apache.http.io.SessionInputBuffer;
import com.cloudera.impala.jdbc42.internal.apache.http.message.BasicLineParser;
import com.cloudera.impala.jdbc42.internal.apache.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(HttpResponseFactory responseFactory) {
        this(null, responseFactory);
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

