/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.jackson;

import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.Level;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.Marker;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.ThreadContext;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.LogEvent;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.impl.ExtendedStackTraceElement;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.impl.ThrowableProxy;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.jackson.ExtendedStackTraceElementMixIn;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.jackson.InstantMixIn;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.jackson.LevelMixIn;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.jackson.Log4jStackTraceElementDeserializer;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.jackson.LogEventJsonMixIn;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.jackson.LogEventWithContextListMixIn;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.jackson.MarkerMixIn;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.jackson.MessageSerializer;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.jackson.MutableThreadContextStackDeserializer;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.jackson.ObjectMessageSerializer;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.jackson.StackTraceElementMixIn;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.jackson.ThrowableProxyMixIn;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.jackson.ThrowableProxyWithStacktraceAsStringMixIn;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.jackson.ThrowableProxyWithoutStacktraceMixIn;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.time.Instant;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.message.Message;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.message.ObjectMessage;
import com.cloudera.impala.jdbc42.internal.fasterxml.jackson.databind.Module;
import com.cloudera.impala.jdbc42.internal.fasterxml.jackson.databind.module.SimpleModule;

class Initializers {
    Initializers() {
    }

    static class SimpleModuleInitializer {
        SimpleModuleInitializer() {
        }

        void initialize(SimpleModule simpleModule, boolean objectMessageAsJsonObject) {
            simpleModule.addDeserializer(StackTraceElement.class, new Log4jStackTraceElementDeserializer());
            simpleModule.addDeserializer(ThreadContext.ContextStack.class, new MutableThreadContextStackDeserializer());
            if (objectMessageAsJsonObject) {
                simpleModule.addSerializer(ObjectMessage.class, new ObjectMessageSerializer());
            }
            simpleModule.addSerializer(Message.class, new MessageSerializer());
        }
    }

    static class SetupContextJsonInitializer {
        SetupContextJsonInitializer() {
        }

        void setupModule(Module.SetupContext context, boolean includeStacktrace, boolean stacktraceAsString) {
            context.setMixInAnnotations(StackTraceElement.class, StackTraceElementMixIn.class);
            context.setMixInAnnotations(Marker.class, MarkerMixIn.class);
            context.setMixInAnnotations(Level.class, LevelMixIn.class);
            context.setMixInAnnotations(Instant.class, InstantMixIn.class);
            context.setMixInAnnotations(LogEvent.class, LogEventJsonMixIn.class);
            context.setMixInAnnotations(ExtendedStackTraceElement.class, ExtendedStackTraceElementMixIn.class);
            context.setMixInAnnotations(ThrowableProxy.class, includeStacktrace ? (stacktraceAsString ? ThrowableProxyWithStacktraceAsStringMixIn.class : ThrowableProxyMixIn.class) : ThrowableProxyWithoutStacktraceMixIn.class);
        }
    }

    static class SetupContextInitializer {
        SetupContextInitializer() {
        }

        void setupModule(Module.SetupContext context, boolean includeStacktrace, boolean stacktraceAsString) {
            context.setMixInAnnotations(StackTraceElement.class, StackTraceElementMixIn.class);
            context.setMixInAnnotations(Marker.class, MarkerMixIn.class);
            context.setMixInAnnotations(Level.class, LevelMixIn.class);
            context.setMixInAnnotations(Instant.class, InstantMixIn.class);
            context.setMixInAnnotations(LogEvent.class, LogEventWithContextListMixIn.class);
            context.setMixInAnnotations(ExtendedStackTraceElement.class, ExtendedStackTraceElementMixIn.class);
            context.setMixInAnnotations(ThrowableProxy.class, includeStacktrace ? (stacktraceAsString ? ThrowableProxyWithStacktraceAsStringMixIn.class : ThrowableProxyMixIn.class) : ThrowableProxyWithoutStacktraceMixIn.class);
        }
    }
}

