/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.apache.logging.slf4j;

import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.LogManager;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.LoggingException;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.spi.AbstractLoggerAdapter;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.spi.LoggerContext;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.status.StatusLogger;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.util.StackLocatorUtil;
import com.cloudera.impala.jdbc42.internal.apache.logging.slf4j.Log4jLogger;
import com.cloudera.impala.jdbc42.internal.slf4j.ILoggerFactory;
import com.cloudera.impala.jdbc42.internal.slf4j.Logger;
import java.util.function.Predicate;

public class Log4jLoggerFactory
extends AbstractLoggerAdapter<Logger>
implements ILoggerFactory {
    private static final StatusLogger LOGGER = StatusLogger.getLogger();
    private static final String SLF4J_PACKAGE = "com.cloudera.impala.jdbc42.internal.slf4j";
    private static final String TO_SLF4J_CONTEXT = "com.cloudera.impala.jdbc42.internal.apache.logging.slf4j.SLF4JLoggerContext";
    private static final Predicate<Class<?>> CALLER_PREDICATE = clazz -> !AbstractLoggerAdapter.class.equals(clazz) && !clazz.getName().startsWith(SLF4J_PACKAGE);

    @Override
    protected Logger newLogger(String name, LoggerContext context) {
        String key = "ROOT".equals(name) ? "" : name;
        return new Log4jLogger(this.validateContext(context).getLogger(key), name);
    }

    @Override
    protected LoggerContext getContext() {
        Class<?> anchor = LogManager.getFactory().isClassLoaderDependent() ? StackLocatorUtil.getCallerClass(Log4jLoggerFactory.class, CALLER_PREDICATE) : null;
        LOGGER.trace("Log4jLoggerFactory.getContext() found anchor {}", (Object)anchor);
        return anchor == null ? LogManager.getContext(false) : this.getContext(anchor);
    }

    private LoggerContext validateContext(LoggerContext context) {
        if (TO_SLF4J_CONTEXT.equals(context.getClass().getName())) {
            throw new LoggingException("log4j-slf4j-impl cannot be present with log4j-to-slf4j");
        }
        return context;
    }
}

