/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.apache.thrift.server;

import com.cloudera.impala.jdbc42.internal.apache.thrift.TException;
import com.cloudera.impala.jdbc42.internal.apache.thrift.TProcessor;
import com.cloudera.impala.jdbc42.internal.apache.thrift.protocol.TProtocol;
import com.cloudera.impala.jdbc42.internal.apache.thrift.protocol.TProtocolFactory;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TIOStreamTransport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class TExtensibleServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private TProcessor processor;
    private TProtocolFactory inFactory;
    private TProtocolFactory outFactory;
    private Collection<Map.Entry<String, String>> customHeaders;

    protected abstract TProcessor getProcessor();

    protected abstract TProtocolFactory getInProtocolFactory();

    protected abstract TProtocolFactory getOutProtocolFactory();

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.processor = this.getProcessor();
        this.inFactory = this.getInProtocolFactory();
        this.outFactory = this.getOutProtocolFactory();
        this.customHeaders = new ArrayList<Map.Entry<String, String>>();
        if (this.processor == null) {
            throw new ServletException("processor must be set");
        }
        if (this.inFactory == null) {
            throw new ServletException("inFactory must be set");
        }
        if (this.outFactory == null) {
            throw new ServletException("outFactory must be set");
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        TIOStreamTransport inTransport = null;
        TIOStreamTransport outTransport = null;
        try {
            TIOStreamTransport transport;
            response.setContentType("application/x-thrift");
            if (null != this.customHeaders) {
                for (Map.Entry<String, String> header : this.customHeaders) {
                    response.addHeader(header.getKey(), header.getValue());
                }
            }
            ServletInputStream in = request.getInputStream();
            ServletOutputStream out = response.getOutputStream();
            inTransport = transport = new TIOStreamTransport((InputStream)in, (OutputStream)out);
            outTransport = transport;
            TProtocol inProtocol = this.inFactory.getProtocol(inTransport);
            TProtocol outProtocol = this.inFactory.getProtocol(outTransport);
            this.processor.process(inProtocol, outProtocol);
            out.flush();
        }
        catch (TException te) {
            throw new ServletException((Throwable)te);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    public void addCustomHeader(final String key, final String value) {
        this.customHeaders.add(new Map.Entry<String, String>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public String getValue() {
                return value;
            }

            @Override
            public String setValue(String value2) {
                return null;
            }
        });
    }

    public void setCustomHeaders(Collection<Map.Entry<String, String>> headers) {
        this.customHeaders.clear();
        this.customHeaders.addAll(headers);
    }
}

