/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.apache.thrift.transport;

import com.cloudera.impala.jdbc42.internal.apache.http.HttpEntity;
import com.cloudera.impala.jdbc42.internal.apache.http.HttpHost;
import com.cloudera.impala.jdbc42.internal.apache.http.HttpResponse;
import com.cloudera.impala.jdbc42.internal.apache.http.client.HttpClient;
import com.cloudera.impala.jdbc42.internal.apache.http.client.methods.HttpPost;
import com.cloudera.impala.jdbc42.internal.apache.http.entity.ByteArrayEntity;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TTransport;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TTransportException;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TTransportFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class THttpClient
extends TTransport {
    private URL url_ = null;
    private final ByteArrayOutputStream requestBuffer_ = new ByteArrayOutputStream();
    private InputStream inputStream_ = null;
    private int connectTimeout_ = 0;
    private int readTimeout_ = 0;
    private Map<String, String> customHeaders_ = null;
    private final HttpHost host;
    private final HttpClient client;

    public THttpClient(String url) throws TTransportException {
        try {
            this.url_ = new URL(url);
            this.client = null;
            this.host = null;
        }
        catch (IOException iox) {
            throw new TTransportException(iox);
        }
    }

    public THttpClient(String url, HttpClient client) throws TTransportException {
        try {
            this.url_ = new URL(url);
            this.client = client;
            this.host = new HttpHost(this.url_.getHost(), -1 == this.url_.getPort() ? this.url_.getDefaultPort() : this.url_.getPort(), this.url_.getProtocol());
        }
        catch (IOException iox) {
            throw new TTransportException(iox);
        }
    }

    public void setConnectTimeout(int timeout) {
        this.connectTimeout_ = timeout;
        if (null != this.client) {
            this.client.getParams().setParameter("http.connection.timeout", this.connectTimeout_);
        }
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout_ = timeout;
        if (null != this.client) {
            this.client.getParams().setParameter("http.socket.timeout", this.readTimeout_);
        }
    }

    public void setCustomHeaders(Map<String, String> headers) {
        this.customHeaders_ = headers;
    }

    public void setCustomHeader(String key, String value) {
        if (this.customHeaders_ == null) {
            this.customHeaders_ = new HashMap<String, String>();
        }
        this.customHeaders_.put(key, value);
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
        if (null != this.inputStream_) {
            try {
                this.inputStream_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inputStream_ = null;
        }
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws TTransportException {
        if (this.inputStream_ == null) {
            throw new TTransportException("Response buffer is empty, no request.");
        }
        try {
            int ret = this.inputStream_.read(buf, off, len);
            if (ret == -1) {
                throw new TTransportException("No more data available.");
            }
            return ret;
        }
        catch (IOException iox) {
            throw new TTransportException(iox);
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.requestBuffer_.write(buf, off, len);
    }

    private static void consume(HttpEntity entity) throws IOException {
        InputStream instream;
        if (entity == null) {
            return;
        }
        if (entity.isStreaming() && (instream = entity.getContent()) != null) {
            instream.close();
        }
    }

    private void flushUsingHttpClient() throws TTransportException {
        if (null == this.client) {
            throw new TTransportException("Null HttpClient, aborting.");
        }
        byte[] data = this.requestBuffer_.toByteArray();
        this.requestBuffer_.reset();
        HttpPost post = null;
        InputStream is = null;
        try {
            post = new HttpPost(this.url_.getFile());
            post.setHeader("Content-Type", "application/x-thrift");
            post.setHeader("Accept", "application/x-thrift");
            post.setHeader("User-Agent", "Java/THttpClient/HC");
            if (null != this.customHeaders_) {
                for (Map.Entry<String, String> header : this.customHeaders_.entrySet()) {
                    post.setHeader(header.getKey(), header.getValue());
                }
            }
            post.setEntity(new ByteArrayEntity(data));
            HttpResponse response = this.client.execute(this.host, post);
            int responseCode = response.getStatusLine().getStatusCode();
            is = response.getEntity().getContent();
            if (responseCode != 200) {
                throw new TTransportException("HTTP Response code: " + responseCode);
            }
            byte[] buf = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int len = 0;
            do {
                if ((len = is.read(buf)) <= 0) continue;
                baos.write(buf, 0, len);
            } while (-1 != len);
            try {
                THttpClient.consume(response.getEntity());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inputStream_ = new ByteArrayInputStream(baos.toByteArray());
        }
        catch (IOException ioe) {
            if (null != post) {
                post.abort();
            }
            throw new TTransportException(ioe);
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    throw new TTransportException(ioe);
                }
            }
            if (post != null) {
                post.releaseConnection();
            }
        }
    }

    @Override
    public void flush() throws TTransportException {
        if (null != this.client) {
            this.flushUsingHttpClient();
            return;
        }
        byte[] data = this.requestBuffer_.toByteArray();
        this.requestBuffer_.reset();
        try {
            HttpURLConnection connection = (HttpURLConnection)this.url_.openConnection();
            if (this.connectTimeout_ > 0) {
                connection.setConnectTimeout(this.connectTimeout_);
            }
            if (this.readTimeout_ > 0) {
                connection.setReadTimeout(this.readTimeout_);
            }
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-thrift");
            connection.setRequestProperty("Accept", "application/x-thrift");
            connection.setRequestProperty("User-Agent", "Java/THttpClient");
            if (this.customHeaders_ != null) {
                for (Map.Entry<String, String> header : this.customHeaders_.entrySet()) {
                    connection.setRequestProperty(header.getKey(), header.getValue());
                }
            }
            connection.setDoOutput(true);
            connection.connect();
            connection.getOutputStream().write(data);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new TTransportException("HTTP Response code: " + responseCode);
            }
            this.inputStream_ = connection.getInputStream();
        }
        catch (IOException iox) {
            throw new TTransportException(iox);
        }
    }

    public static class Factory
    extends TTransportFactory {
        private final String url;
        private final HttpClient client;

        public Factory(String url) {
            this.url = url;
            this.client = null;
        }

        public Factory(String url, HttpClient client) {
            this.url = url;
            this.client = client;
        }

        @Override
        public TTransport getTransport(TTransport trans) {
            try {
                if (null != this.client) {
                    return new THttpClient(this.url, this.client);
                }
                return new THttpClient(this.url);
            }
            catch (TTransportException tte) {
                return null;
            }
        }
    }
}

