/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.slf4j.impl;

import com.cloudera.impala.jdbc42.internal.apache.log4j.Category;
import com.cloudera.impala.jdbc42.internal.apache.log4j.Level;
import com.cloudera.impala.jdbc42.internal.apache.log4j.Logger;
import com.cloudera.impala.jdbc42.internal.apache.log4j.Priority;
import com.cloudera.impala.jdbc42.internal.apache.log4j.spi.LocationInfo;
import com.cloudera.impala.jdbc42.internal.apache.log4j.spi.LoggingEvent;
import com.cloudera.impala.jdbc42.internal.apache.log4j.spi.ThrowableInformation;
import com.cloudera.impala.jdbc42.internal.slf4j.Marker;
import com.cloudera.impala.jdbc42.internal.slf4j.helpers.FormattingTuple;
import com.cloudera.impala.jdbc42.internal.slf4j.helpers.MarkerIgnoringBase;
import com.cloudera.impala.jdbc42.internal.slf4j.helpers.MessageFormatter;
import com.cloudera.impala.jdbc42.internal.slf4j.spi.LocationAwareLogger;
import java.io.Serializable;

public final class Log4jLoggerAdapter
extends MarkerIgnoringBase
implements LocationAwareLogger,
Serializable {
    private static final long serialVersionUID = 6182834493563598289L;
    final transient Logger logger;
    static final String FQCN = Log4jLoggerAdapter.class.getName();
    final boolean traceCapable;

    Log4jLoggerAdapter(Logger logger) {
        this.logger = logger;
        this.name = logger.getName();
        this.traceCapable = this.isTraceCapable();
    }

    private boolean isTraceCapable() {
        try {
            this.logger.isTraceEnabled();
            return true;
        }
        catch (NoSuchMethodError e) {
            return false;
        }
    }

    public boolean isTraceEnabled() {
        if (this.traceCapable) {
            return this.logger.isTraceEnabled();
        }
        return this.logger.isDebugEnabled();
    }

    public void trace(String msg) {
        this.logger.log(FQCN, (Priority)(this.traceCapable ? Level.TRACE : Level.DEBUG), (Object)msg, null);
    }

    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            this.logger.log(FQCN, (Priority)(this.traceCapable ? Level.TRACE : Level.DEBUG), (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
            this.logger.log(FQCN, (Priority)(this.traceCapable ? Level.TRACE : Level.DEBUG), (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
            this.logger.log(FQCN, (Priority)(this.traceCapable ? Level.TRACE : Level.DEBUG), (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    public void trace(String msg, Throwable t) {
        this.logger.log(FQCN, (Priority)(this.traceCapable ? Level.TRACE : Level.DEBUG), (Object)msg, t);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String msg) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)msg, null);
    }

    public void debug(String format, Object arg) {
        if (this.logger.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.logger.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
            this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.logger.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
            this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    public void debug(String msg, Throwable t) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)msg, t);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(String msg) {
        this.logger.log(FQCN, (Priority)Level.INFO, (Object)msg, null);
    }

    public void info(String format, Object arg) {
        if (this.logger.isInfoEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            this.logger.log(FQCN, (Priority)Level.INFO, (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.logger.isInfoEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
            this.logger.log(FQCN, (Priority)Level.INFO, (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    public void info(String format, Object ... argArray) {
        if (this.logger.isInfoEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, argArray);
            this.logger.log(FQCN, (Priority)Level.INFO, (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    public void info(String msg, Throwable t) {
        this.logger.log(FQCN, (Priority)Level.INFO, (Object)msg, t);
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    public void warn(String msg) {
        this.logger.log(FQCN, (Priority)Level.WARN, (Object)msg, null);
    }

    public void warn(String format, Object arg) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            this.logger.log(FQCN, (Priority)Level.WARN, (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
            this.logger.log(FQCN, (Priority)Level.WARN, (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    public void warn(String format, Object ... argArray) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, argArray);
            this.logger.log(FQCN, (Priority)Level.WARN, (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    public void warn(String msg, Throwable t) {
        this.logger.log(FQCN, (Priority)Level.WARN, (Object)msg, t);
    }

    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    public void error(String msg) {
        this.logger.log(FQCN, (Priority)Level.ERROR, (Object)msg, null);
    }

    public void error(String format, Object arg) {
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            this.logger.log(FQCN, (Priority)Level.ERROR, (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
            this.logger.log(FQCN, (Priority)Level.ERROR, (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    public void error(String format, Object ... argArray) {
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, argArray);
            this.logger.log(FQCN, (Priority)Level.ERROR, (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    public void error(String msg, Throwable t) {
        this.logger.log(FQCN, (Priority)Level.ERROR, (Object)msg, t);
    }

    public void log(Marker marker, String callerFQCN, int level, String msg, Object[] argArray, Throwable t) {
        Level log4jLevel = this.toLog4jLevel(level);
        this.logger.log(callerFQCN, (Priority)log4jLevel, (Object)msg, t);
    }

    private Level toLog4jLevel(int level) {
        Level log4jLevel;
        switch (level) {
            case 0: {
                log4jLevel = this.traceCapable ? Level.TRACE : Level.DEBUG;
                break;
            }
            case 10: {
                log4jLevel = Level.DEBUG;
                break;
            }
            case 20: {
                log4jLevel = Level.INFO;
                break;
            }
            case 30: {
                log4jLevel = Level.WARN;
                break;
            }
            case 40: {
                log4jLevel = Level.ERROR;
                break;
            }
            default: {
                throw new IllegalStateException("Level number " + level + " is not recognized.");
            }
        }
        return log4jLevel;
    }

    public void log(com.cloudera.impala.jdbc42.internal.slf4j.event.LoggingEvent event) {
        Level log4jLevel = this.toLog4jLevel(event.getLevel().toInt());
        if (!this.logger.isEnabledFor((Priority)log4jLevel)) {
            return;
        }
        LoggingEvent log4jevent = this.toLog4jEvent(event, log4jLevel);
        this.logger.callAppenders(log4jevent);
    }

    private LoggingEvent toLog4jEvent(com.cloudera.impala.jdbc42.internal.slf4j.event.LoggingEvent event, Level log4jLevel) {
        FormattingTuple ft = MessageFormatter.format(event.getMessage(), event.getArgumentArray(), event.getThrowable());
        LocationInfo locationInfo = new LocationInfo("NA/SubstituteLogger", "NA/SubstituteLogger", "NA/SubstituteLogger", "0");
        ThrowableInformation ti = null;
        Throwable t = ft.getThrowable();
        if (t != null) {
            ti = new ThrowableInformation(t);
        }
        LoggingEvent log4jEvent = new LoggingEvent(FQCN, (Category)this.logger, event.getTimeStamp(), log4jLevel, (Object)ft.getMessage(), event.getThreadName(), ti, null, locationInfo, null);
        return log4jEvent;
    }
}

