/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.aeprocessor.aetree.value;

import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.impala.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.impala.sqlengine.dsiext.dataengine.ICoercionHandler;
import com.cloudera.impala.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.cloudera.impala.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.impala.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.cloudera.impala.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.impala.sqlengine.executor.datawrapper.SqlBigIntDataWrapper;
import com.cloudera.impala.sqlengine.executor.datawrapper.SqlBinaryDataWrapper;
import com.cloudera.impala.sqlengine.executor.datawrapper.SqlCharDataWrapper;
import com.cloudera.impala.sqlengine.executor.datawrapper.SqlDateDataWrapper;
import com.cloudera.impala.sqlengine.executor.datawrapper.SqlDoubleDataWrapper;
import com.cloudera.impala.sqlengine.executor.datawrapper.SqlExactNumDataWrapper;
import com.cloudera.impala.sqlengine.executor.datawrapper.SqlIntegerDataWrapper;
import com.cloudera.impala.sqlengine.executor.datawrapper.SqlRealDataWrapper;
import com.cloudera.impala.sqlengine.executor.datawrapper.SqlSmallIntDataWrapper;
import com.cloudera.impala.sqlengine.executor.datawrapper.SqlTimeDataWrapper;
import com.cloudera.impala.sqlengine.executor.datawrapper.SqlTimestampDataWrapper;
import com.cloudera.impala.sqlengine.executor.datawrapper.SqlTinyIntDataWrapper;
import com.cloudera.impala.sqlengine.parser.type.PTLiteralType;
import com.cloudera.impala.support.conv.CharConverter;
import com.cloudera.impala.support.conv.ConversionResult;
import com.cloudera.impala.support.conv.HexToBinaryConverter;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.AbstractList;
import java.util.Iterator;

public class AELiteral
extends AEValueExpr {
    private String m_literalStr;
    private PTLiteralType m_literalType;
    private IColumn m_metaData;
    private boolean m_isSigned;

    public AELiteral(String string, PTLiteralType pTLiteralType, SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        this(string, pTLiteralType, false, sqlDataEngineContext);
    }

    public AELiteral(String string, PTLiteralType pTLiteralType, boolean bl, SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        if (pTLiteralType == PTLiteralType.BINARY) {
            if (string.length() % 2 != 0) {
                throw SQLEngineExceptionFactory.oddNumberHexDigitsException(string);
            }
            assert (string.substring(0, 2).equals("0x") || string.substring(0, 2).equals("0X"));
            this.m_literalStr = string.substring(2, string.length());
        } else {
            this.m_literalStr = pTLiteralType == PTLiteralType.CHARSTR ? string : string.trim();
        }
        this.m_literalType = pTLiteralType;
        this.m_isSigned = bl;
        IColumn iColumn = this.getLiteralMetadata(this.m_literalStr, pTLiteralType, bl, sqlDataEngineContext);
        if ("".equals(iColumn.getName())) {
            ColumnMetadata columnMetadata = ColumnMetadata.copyOf(iColumn);
            columnMetadata.setName(null);
            iColumn = columnMetadata;
        }
        this.m_metaData = iColumn;
    }

    public AELiteral(AELiteral aELiteral) {
        super(aELiteral);
        this.m_literalStr = aELiteral.m_literalStr;
        this.m_literalType = aELiteral.m_literalType;
        this.m_isSigned = aELiteral.m_isSigned;
        this.m_metaData = ColumnMetadata.copyOf(aELiteral.m_metaData);
    }

    public String getStringValue() {
        return this.m_literalStr;
    }

    public PTLiteralType getLiteralType() {
        return this.m_literalType;
    }

    @Override
    public IColumn getColumn() {
        return this.m_metaData;
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public AELiteral copy() {
        return new AELiteral(this);
    }

    public Iterator<IAENode> getChildItr() {
        AbstractList<IAENode> abstractList = new AbstractList<IAENode>(){

            @Override
            public IAENode get(int n) {
                throw new IndexOutOfBoundsException("Child index out of bound for AELiteral");
            }

            @Override
            public int size() {
                return 0;
            }
        };
        return abstractList.iterator();
    }

    @Override
    public String getLogString() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append(this.getClass().getSimpleName() + ": " + this.m_literalStr + ": ");
        switch (this.m_literalType) {
            case TIMESTAMP: {
                stringBuilder.append("Date Time Literal");
                break;
            }
            case DATE: {
                stringBuilder.append("Date Literal");
                break;
            }
            case TIME: {
                stringBuilder.append("Time Literal");
                break;
            }
            case APPROXNUM: {
                stringBuilder.append("Approximate Numeric Literal");
                break;
            }
            case DECIMAL: {
                stringBuilder.append("Decimal Numeric Literal");
                break;
            }
            case CHARSTR: {
                stringBuilder.append("Character String Literal");
                break;
            }
            case USINT: {
                if (this.m_isSigned) {
                    stringBuilder.append("Signed Integer Literal");
                    break;
                }
                stringBuilder.append("Unsigned Integer Literal");
                break;
            }
            case DATATYPE: {
                stringBuilder.append("SQL Data Type Keyword Literal");
                break;
            }
            case BINARY: {
                stringBuilder.append("Binary Literal");
                break;
            }
            default: {
                stringBuilder.append(this.m_literalType.name());
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public int getNumChildren() {
        return 0;
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (iAENode == this) {
            return true;
        }
        if (!(iAENode instanceof AELiteral)) {
            return false;
        }
        AELiteral aELiteral = (AELiteral)iAENode;
        return this.m_isSigned == aELiteral.m_isSigned && this.m_literalStr.equals(aELiteral.m_literalStr) && this.m_literalType == aELiteral.m_literalType && this.m_metaData.equals(aELiteral.m_metaData);
    }

    private IColumn getLiteralMetadata(String string, PTLiteralType pTLiteralType, boolean bl, SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        ICoercionHandler iCoercionHandler = sqlDataEngineContext.getCoercionHandler();
        switch (pTLiteralType) {
            case DATATYPE: {
                return iCoercionHandler.determineLiteralColumn(string, ICoercionHandler.LiteralType.DATATYPE);
            }
            case BINARY: {
                return iCoercionHandler.determineLiteralColumn(string, ICoercionHandler.LiteralType.BINARY);
            }
            case CHARSTR: {
                return iCoercionHandler.determineLiteralColumn(string, ICoercionHandler.LiteralType.CHAR);
            }
            case USINT: {
                return iCoercionHandler.determineLiteralColumn(string, ICoercionHandler.LiteralType.UNSIGNED_INT);
            }
            case SINT: {
                return iCoercionHandler.determineLiteralColumn(string, ICoercionHandler.LiteralType.SIGNED_INT);
            }
            case APPROXNUM: {
                return iCoercionHandler.determineLiteralColumn(string, ICoercionHandler.LiteralType.APROX_NUM);
            }
            case DECIMAL: {
                return iCoercionHandler.determineLiteralColumn(string, ICoercionHandler.LiteralType.EXACT_NUM);
            }
            case DATE: {
                return iCoercionHandler.determineLiteralColumn(string, ICoercionHandler.LiteralType.DATE);
            }
            case TIME: {
                return iCoercionHandler.determineLiteralColumn(string, ICoercionHandler.LiteralType.TIME);
            }
            case TIMESTAMP: {
                return iCoercionHandler.determineLiteralColumn(string, ICoercionHandler.LiteralType.TIMESTAMP);
            }
        }
        throw new IllegalArgumentException("Unrecognized literal type.");
    }

    @Override
    public void updateColumn() throws ErrorException {
    }

    public ISqlDataWrapper createDataWrapper(ConversionResult conversionResult) throws ErrorException {
        DefaultSqlDataWrapper defaultSqlDataWrapper;
        TypeMetadata typeMetadata = this.m_metaData.getTypeMetadata();
        short s = typeMetadata.getType();
        switch (s) {
            case -5: {
                defaultSqlDataWrapper = new SqlBigIntDataWrapper();
                defaultSqlDataWrapper.setBigInt(CharConverter.toBigInt(this.m_literalStr, conversionResult, typeMetadata.isSigned()));
                break;
            }
            case 2: 
            case 3: {
                defaultSqlDataWrapper = new SqlExactNumDataWrapper(s);
                defaultSqlDataWrapper.setExactNumber(CharConverter.toExactNum(this.m_literalStr, conversionResult, typeMetadata.getPrecision(), typeMetadata.getScale()));
                break;
            }
            case 6: 
            case 8: {
                defaultSqlDataWrapper = new SqlDoubleDataWrapper(s);
                defaultSqlDataWrapper.setDouble(CharConverter.toDouble(this.m_literalStr, conversionResult));
                break;
            }
            case 7: {
                defaultSqlDataWrapper = new SqlRealDataWrapper();
                defaultSqlDataWrapper.setReal(CharConverter.toReal(this.m_literalStr, conversionResult));
                break;
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                defaultSqlDataWrapper = new SqlCharDataWrapper(s);
                defaultSqlDataWrapper.setChar(this.m_literalStr);
                conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
                break;
            }
            case 91: {
                defaultSqlDataWrapper = new SqlDateDataWrapper();
                defaultSqlDataWrapper.setDate(CharConverter.toDate(this.m_literalStr, conversionResult, null));
                break;
            }
            case 92: {
                defaultSqlDataWrapper = new SqlTimeDataWrapper();
                defaultSqlDataWrapper.setTime(CharConverter.toTime(this.m_literalStr, conversionResult, typeMetadata.getPrecision(), null));
                break;
            }
            case 93: {
                defaultSqlDataWrapper = new SqlTimestampDataWrapper();
                defaultSqlDataWrapper.setTimestamp(CharConverter.toTimestamp(this.m_literalStr, conversionResult, typeMetadata.getPrecision(), null));
                break;
            }
            case 4: {
                defaultSqlDataWrapper = new SqlIntegerDataWrapper();
                defaultSqlDataWrapper.setInteger(CharConverter.toInteger(this.m_literalStr, conversionResult, typeMetadata.isSigned()));
                break;
            }
            case 5: {
                defaultSqlDataWrapper = new SqlSmallIntDataWrapper();
                defaultSqlDataWrapper.setSmallInt(CharConverter.toSmallint(this.m_literalStr, conversionResult, typeMetadata.isSigned()));
                break;
            }
            case -6: {
                defaultSqlDataWrapper = new SqlTinyIntDataWrapper();
                defaultSqlDataWrapper.setTinyInt(CharConverter.toTinyint(this.m_literalStr, conversionResult, typeMetadata.isSigned()));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                defaultSqlDataWrapper = new SqlBinaryDataWrapper(s);
                defaultSqlDataWrapper.setBinary(HexToBinaryConverter.toBinary(this.m_literalStr, this.m_metaData.getColumnLength(), conversionResult));
                break;
            }
            case -11: 
            case -7: 
            case 16: {
                throw SQLEngineExceptionFactory.featureNotImplementedException(typeMetadata.getTypeName() + " literal.");
            }
            default: {
                throw SQLEngineExceptionFactory.featureNotImplementedException("ISqlDataWrapper for type: " + typeMetadata.getTypeName());
            }
        }
        return defaultSqlDataWrapper;
    }
}

