/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.dsiext.dataengine;

import com.cloudera.impala.dsi.core.impl.DSIDriver;
import com.cloudera.impala.dsi.core.impl.DSIDriverSingleton;
import com.cloudera.impala.dsi.core.interfaces.IStatement;
import com.cloudera.impala.dsi.core.utilities.AttributeDataMap;
import com.cloudera.impala.dsi.core.utilities.PropertyUtilities;
import com.cloudera.impala.dsi.core.utilities.Variant;
import com.cloudera.impala.dsi.core.utilities.Variants;
import com.cloudera.impala.dsi.dataengine.filters.IFilter;
import com.cloudera.impala.dsi.dataengine.impl.DSIDataEngine;
import com.cloudera.impala.dsi.dataengine.impl.DSIEmptyMetadataSource;
import com.cloudera.impala.dsi.dataengine.interfaces.IMetadataSource;
import com.cloudera.impala.dsi.dataengine.interfaces.IQueryExecutor;
import com.cloudera.impala.dsi.dataengine.interfaces.IResultSet;
import com.cloudera.impala.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.cloudera.impala.dsi.dataengine.utilities.MetadataSourceID;
import com.cloudera.impala.dsi.dataengine.utilities.OrderType;
import com.cloudera.impala.dsi.exceptions.BadAttrValException;
import com.cloudera.impala.dsi.exceptions.BadPropertyKeyException;
import com.cloudera.impala.dsi.exceptions.IncorrectTypeException;
import com.cloudera.impala.dsi.exceptions.InvalidOperationException;
import com.cloudera.impala.dsi.exceptions.NumericOverflowException;
import com.cloudera.impala.dsi.exceptions.ParsingException;
import com.cloudera.impala.dsi.utilities.DSIMessageKey;
import com.cloudera.impala.sqlengine.SQLEngineGenericContext;
import com.cloudera.impala.sqlengine.aeprocessor.aebuilder.AETreeBuilder;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEStatements;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.IAEStatement;
import com.cloudera.impala.sqlengine.aeprocessor.metadatautil.AEMetadataCoercionHandler;
import com.cloudera.impala.sqlengine.dsiext.dataengine.CustomScalarFunction;
import com.cloudera.impala.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.cloudera.impala.sqlengine.dsiext.dataengine.DSIExtOperationHandlerFactory;
import com.cloudera.impala.sqlengine.dsiext.dataengine.ICoercionHandler;
import com.cloudera.impala.sqlengine.dsiext.dataengine.IMetadataHelper;
import com.cloudera.impala.sqlengine.dsiext.dataengine.OpenTableType;
import com.cloudera.impala.sqlengine.dsiext.dataengine.SqlCustomBehaviourProvider;
import com.cloudera.impala.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.cloudera.impala.sqlengine.dsiext.dataengine.SqlQueryExecutor;
import com.cloudera.impala.sqlengine.dsiext.dataengine.StoredProcedure;
import com.cloudera.impala.sqlengine.dsiext.dataengine.ddl.TableSpecification;
import com.cloudera.impala.sqlengine.dsiext.dataengine.metadata.DSIExtCatalogSchemasOnlyMetadataSource;
import com.cloudera.impala.sqlengine.dsiext.dataengine.metadata.DSIExtCatalogsOnlyMetadataSource;
import com.cloudera.impala.sqlengine.dsiext.dataengine.metadata.DSIExtColumnsMetadataSource;
import com.cloudera.impala.sqlengine.dsiext.dataengine.metadata.DSIExtProcedureColumnsMetadataSource;
import com.cloudera.impala.sqlengine.dsiext.dataengine.metadata.DSIExtProceduresMetadataSource;
import com.cloudera.impala.sqlengine.dsiext.dataengine.metadata.DSIExtSchemasOnlyMetadataSource;
import com.cloudera.impala.sqlengine.dsiext.dataengine.metadata.DSIExtTablesMetadataSource;
import com.cloudera.impala.sqlengine.dsiext.dataengine.metadata.DSIExtTypeInfoMetadataSource;
import com.cloudera.impala.sqlengine.exceptions.SQLEngineException;
import com.cloudera.impala.sqlengine.executor.conversions.SqlConverterGenerator;
import com.cloudera.impala.sqlengine.parser.DefaultLimitChecker;
import com.cloudera.impala.sqlengine.parser.IPTLimitChecker;
import com.cloudera.impala.sqlengine.parser.PTParser;
import com.cloudera.impala.sqlengine.parser.parsetree.IPTNode;
import com.cloudera.impala.sqlengine.utilities.AEStringLogger;
import com.cloudera.impala.sqlengine.utilities.PTStringLogger;
import com.cloudera.impala.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.MessageSourceImpl;
import com.cloudera.impala.support.SettingReader;
import com.cloudera.impala.support.exceptions.DiagState;
import com.cloudera.impala.support.exceptions.ErrorException;
import com.cloudera.impala.support.exceptions.ExceptionType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;

public abstract class SqlDataEngine
extends DSIDataEngine {
    private AttributeDataMap m_engineProperties = new AttributeDataMap();
    private SqlDataEngineContext m_context = null;

    protected SqlDataEngine(IStatement iStatement) throws ErrorException {
        super(iStatement);
        this.loadProperties();
    }

    public ICoercionHandler createCoercionHandler() {
        return new AEMetadataCoercionHandler();
    }

    protected IQueryExecutor createQueryExecutor(AEStatements aEStatements) throws ErrorException {
        return new SqlQueryExecutor(aEStatements, this.getContext(), this.getLog());
    }

    public IMetadataHelper createMetadataHelper() {
        return null;
    }

    public DSIExtOperationHandlerFactory createOperationHandlerFactory() {
        return null;
    }

    public SqlCustomBehaviourProvider createCustomBehaviorProvider() {
        return new SqlCustomBehaviourProvider();
    }

    public SqlConverterGenerator createSqlConverterGenerator() {
        return SqlDataEngine.getSharedSqlConverterGenerator();
    }

    public void createTable(TableSpecification tableSpecification) throws ErrorException {
        throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.CREATE_TABLE_NOT_SUPPORTED.name());
    }

    public boolean doesTableExist(String string, String string2, String string3) throws ErrorException {
        return null != this.openTable(string, string2, string3, OpenTableType.READ_ONLY);
    }

    public void dropTable(String string, String string2, String string3, DropTableOption dropTableOption) throws ErrorException {
        throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.DROP_TABLE_NOT_SUPPORTED.name());
    }

    public SqlDataEngineContext getContext() {
        if (null == this.m_context) {
            throw new InvalidOperationException();
        }
        return this.m_context;
    }

    public Variant getProperty(int n) throws BadPropertyKeyException, ErrorException {
        if (null == this.m_engineProperties) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_PROPMAP.name());
        }
        if (this.m_engineProperties.isProperty(n)) {
            return this.m_engineProperties.getProperty(n);
        }
        throw new BadPropertyKeyException(2, DSIMessageKey.INVALID_PROPKEY.name(), String.valueOf(n));
    }

    public AttributeDataMap getPropertyMap() {
        return this.m_engineProperties;
    }

    public StoredProcedure openProcedure(String string, String string2, String string3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), string, string2, string3);
        return null;
    }

    public CustomScalarFunction openScalarFunction(String string, int n) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), string, n);
        return null;
    }

    public abstract DSIExtJResultSet openTable(String var1, String var2, String var3, OpenTableType var4) throws ErrorException;

    protected IPTLimitChecker getLimitChecker() throws ErrorException {
        if (this.getProperty(6).getString().equalsIgnoreCase("Y")) {
            return null;
        }
        DefaultLimitChecker defaultLimitChecker = new DefaultLimitChecker();
        defaultLimitChecker.initLimitCheckValues(this.getParentStatement().getParentConnection());
        return defaultLimitChecker;
    }

    @Override
    public IQueryExecutor prepare(String string) throws ParsingException, ErrorException {
        Object object;
        Object object2;
        IPTNode iPTNode;
        IPTLimitChecker iPTLimitChecker = this.getLimitChecker();
        IPTNode iPTNode2 = iPTNode = iPTLimitChecker == null ? PTParser.parse(string) : PTParser.parse(string, iPTLimitChecker);
        if (this.getProperty(7).getString().equalsIgnoreCase("Y")) {
            object2 = SettingReader.readSetting("LogPath");
            object = new File((String)object2, "ParseTree.log");
            try {
                PTStringLogger.writePTLogString(iPTNode, new FileOutputStream((File)object));
            }
            catch (Exception exception) {
                this.getLog().logError(this.getClass().getPackage().getName(), this.getClass().getName(), "prepare", "Could not create or write to ParseTree.log");
            }
        }
        this.m_context = new SqlDataEngineContext(this.getParentStatement(), this);
        object2 = AETreeBuilder.build(iPTNode, this);
        try {
            if (0L != (this.getProperty(4).getLong() & 1L)) {
                object = SettingReader.readSetting("LogPath");
                File file = new File((String)object, "AETree.log");
                AEStringLogger.logAETree((IAENode)object2, file.getPath(), new Timestamp(System.currentTimeMillis()).toString() + " :: Pre-Optimize ==============================================================");
            }
        }
        catch (IOException iOException) {
            this.getLog().logError(this.getClass().getPackage().getName(), this.getClass().getName(), "prepare", "Could not create or write to AETree.log");
        }
        catch (NumericOverflowException numericOverflowException) {
            throw new AssertionError((Object)numericOverflowException);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new AssertionError((Object)incorrectTypeException);
        }
        object = new AEStatements();
        ((AEStatements)object).addStatement((IAEStatement)object2);
        return this.createQueryExecutor((AEStatements)object);
    }

    @Override
    public IQueryExecutor prepareBatch(List<String> list) throws ParsingException, ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_ACTION_SQLENGINE.name());
    }

    @Override
    public void setDirectExecute() {
    }

    @Override
    public void setMetadataNeeded(boolean bl) {
    }

    public void setProperty(int n, Variant variant) throws BadAttrValException, ErrorException {
        if (null == this.m_engineProperties) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_PROPMAP.name());
        }
        this.m_engineProperties.setProperty(n, variant);
    }

    @Override
    protected IResultSet getMetadataResultImplementation(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, IMetadataSource iMetadataSource, List<IFilter> list, OrderType orderType) throws ErrorException {
        if (null == iMetadataSource) {
            iMetadataSource = this.CreateDefaultMetadataImplementation(metadataSourceID, map, list);
        }
        return super.getMetadataResultImplementation(metadataSourceID, map, iMetadataSource, list, orderType);
    }

    private IMetadataSource CreateDefaultMetadataImplementation(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, List<IFilter> list) throws ErrorException {
        IMetadataHelper iMetadataHelper = this.createMetadataHelper();
        if (null == iMetadataHelper) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.OPTIONAL_FEAT_NOT_IMPL.name(), "Metadata source function", ExceptionType.FEATURE_NOT_IMPLEMENTED);
        }
        switch (metadataSourceID) {
            case COLUMNS: {
                return new DSIExtColumnsMetadataSource(this.getLog(), iMetadataHelper, this, list);
            }
            case CATALOG_ONLY: {
                if (!PropertyUtilities.hasCatalogSupport(this.getParentStatement().getParentConnection())) {
                    throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.OPTIONAL_FEAT_NOT_IMPL.name(), "Catalog", ExceptionType.FEATURE_NOT_IMPLEMENTED);
                }
                return new DSIExtCatalogsOnlyMetadataSource(this.getLog(), iMetadataHelper);
            }
            case CATALOG_SCHEMA_ONLY: {
                if (!PropertyUtilities.hasSchemaSupport(this.getParentStatement().getParentConnection())) {
                    throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.OPTIONAL_FEAT_NOT_IMPL.name(), "Schema", ExceptionType.FEATURE_NOT_IMPLEMENTED);
                }
                return new DSIExtCatalogSchemasOnlyMetadataSource(this.getLog(), iMetadataHelper, list);
            }
            case SCHEMA_ONLY: {
                if (!PropertyUtilities.hasSchemaSupport(this.getParentStatement().getParentConnection())) {
                    throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.OPTIONAL_FEAT_NOT_IMPL.name(), "Schema", ExceptionType.FEATURE_NOT_IMPLEMENTED);
                }
                return new DSIExtSchemasOnlyMetadataSource(this.getLog(), iMetadataHelper, list);
            }
            case TABLES: {
                return new DSIExtTablesMetadataSource(this.getLog(), iMetadataHelper, this.getIsODBC2(), list);
            }
            case TYPE_INFO: {
                return new DSIExtTypeInfoMetadataSource(this.getLog(), this.getIsODBC2());
            }
            case PROCEDURES: {
                return new DSIExtProceduresMetadataSource(this.getLog(), iMetadataHelper, this, list);
            }
            case PROCEDURE_COLUMNS: {
                return new DSIExtProcedureColumnsMetadataSource(this.getLog(), map, iMetadataHelper, this, list);
            }
        }
        return new DSIEmptyMetadataSource(this.getLog());
    }

    private void loadProperties() {
        this.m_engineProperties.setProperty(0, Variants.makeWString("N"));
        this.m_engineProperties.setProperty(2, Variants.makeWString("N"));
        this.m_engineProperties.setProperty(3, Variants.makeWString("Y"));
        try {
            this.m_engineProperties.setProperty(4, Variants.makeUInt32(0L));
        }
        catch (NumericOverflowException numericOverflowException) {
            throw new AssertionError((Object)numericOverflowException);
        }
        this.m_engineProperties.setProperty(5, Variants.makeWString("Y"));
        this.m_engineProperties.setProperty(6, Variants.makeWString("N"));
        this.m_engineProperties.setProperty(7, Variants.makeWString("N"));
        this.m_engineProperties.setProperty(8, Variants.makeWString("N"));
        this.m_engineProperties.setProperty(9, Variants.makeWString("N"));
        this.m_engineProperties.setProperty(10, Variants.makeWString("Y"));
        this.m_engineProperties.setProperty(13, Variants.makeInt64(1000000L));
        this.m_engineProperties.setProperty(14, Variants.makeInt32(1000000));
        int n = 50;
        try {
            String string = System.getProperty("os.name").toLowerCase();
            if (string.contains("windows")) {
                n = 100;
            } else if (string.contains("mac") || string.contains("darwin") || string.contains("sunos") || string.contains("solaris")) {
                n = 20;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.m_engineProperties.setProperty(16, Variants.makeInt32(n));
        this.m_engineProperties.setProperty(15, Variants.makeWString("Y"));
    }

    public static SqlConverterGenerator getSharedSqlConverterGenerator() {
        return Holder.INSTANCE;
    }

    static {
        SQLEngineGenericContext.setDefaultMsgSource((MessageSourceImpl)DSIDriverSingleton.getInstance().getMessageSource());
    }

    private static class Holder {
        public static final SqlConverterGenerator INSTANCE = new SqlConverterGenerator();

        private Holder() {
        }
    }

    public static enum DropTableOption {
        DROP_TABLE_CASCADE,
        DROP_TABLE_RESTRICT,
        DROP_TABLE_UNSPECIFIED;

    }
}

