/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.dsiext.dataengine.metadata;

import com.cloudera.impala.dsi.core.impl.DSIDriver;
import com.cloudera.impala.dsi.dataengine.filters.IFilter;
import com.cloudera.impala.dsi.dataengine.filters.StringFilter;
import com.cloudera.impala.dsi.dataengine.interfaces.IMetadataSource;
import com.cloudera.impala.dsi.dataengine.utilities.DSITypeUtilities;
import com.cloudera.impala.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.impala.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.cloudera.impala.dsi.utilities.DSIMessageKey;
import com.cloudera.impala.dsi.utilities.NullSafeStringComparator;
import com.cloudera.impala.sqlengine.dsiext.dataengine.IMetadataHelper;
import com.cloudera.impala.sqlengine.dsiext.dataengine.Identifier;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.Pair;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class DSIExtCatalogSchemasOnlyMetadataSource
implements IMetadataSource {
    private ILogger m_logger;
    private IMetadataHelper m_metadataHelper;
    private List<Pair<String, String>> m_catalogSchemaPairList;
    private int m_currRow = -1;
    private IFilter m_catalogFilter;
    private IFilter m_schemaFilter;

    @Deprecated
    public DSIExtCatalogSchemasOnlyMetadataSource(ILogger iLogger, Map<MetadataSourceColumnTag, String> map, IMetadataHelper iMetadataHelper) {
        this(iLogger, iMetadataHelper, DSIExtCatalogSchemasOnlyMetadataSource.createFilters(map));
    }

    public DSIExtCatalogSchemasOnlyMetadataSource(ILogger iLogger, IMetadataHelper iMetadataHelper, List<IFilter> list) {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        this.m_logger = iLogger;
        this.m_metadataHelper = iMetadataHelper;
        for (IFilter iFilter : list) {
            if (MetadataSourceColumnTag.CATALOG_NAME == iFilter.getColumnTag()) {
                this.m_catalogFilter = iFilter;
                continue;
            }
            if (MetadataSourceColumnTag.SCHEMA_NAME != iFilter.getColumnTag()) continue;
            this.m_schemaFilter = iFilter;
        }
        this.findCatalogSchemas();
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        Pair<String, String> pair = this.m_catalogSchemaPairList.get(this.m_currRow);
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(pair.key(), dataWrapper, l, l2);
            }
            case SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(pair.value(), dataWrapper, l, l2);
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_METADATA_COLUMN_TAG.name(), metadataSourceColumnTag.name());
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_currRow < this.m_catalogSchemaPairList.size() - 1;
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_currRow < this.m_catalogSchemaPairList.size()) {
            ++this.m_currRow;
        }
        return this.m_currRow < this.m_catalogSchemaPairList.size();
    }

    private void findCatalogSchemas() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Comparator<Pair<String, String>> comparator = new Comparator<Pair<String, String>>(){

            @Override
            public int compare(Pair<String, String> pair, Pair<String, String> pair2) {
                int n = NullSafeStringComparator.INSTANCE.compare(pair.key(), pair2.key());
                return n == 0 ? NullSafeStringComparator.INSTANCE.compare(pair.value(), pair2.value()) : n;
            }
        };
        Identifier identifier = new Identifier();
        TreeSet<Pair<String, String>> treeSet = new TreeSet<Pair<String, String>>(comparator);
        while (this.m_metadataHelper.getNextTable(identifier)) {
            if (!this.filter(this.m_catalogFilter, identifier.getCatalog()) || !this.filter(this.m_schemaFilter, identifier.getSchema())) continue;
            treeSet.add(new Pair<String, String>(identifier.getCatalog(), identifier.getSchema()));
        }
        this.m_catalogSchemaPairList = Collections.unmodifiableList(new ArrayList<Pair<String, String>>(treeSet));
    }

    private boolean filter(IFilter iFilter, String string) {
        if (null == iFilter) {
            return true;
        }
        DataWrapper dataWrapper = new DataWrapper();
        dataWrapper.setChar(string);
        return iFilter.filter(dataWrapper);
    }

    private static List<IFilter> createFilters(Map<MetadataSourceColumnTag, String> map) {
        ArrayList<IFilter> arrayList = new ArrayList<IFilter>(map.size());
        for (MetadataSourceColumnTag metadataSourceColumnTag : map.keySet()) {
            arrayList.add(new StringFilter(metadataSourceColumnTag, map.get((Object)metadataSourceColumnTag), true));
        }
        return arrayList;
    }
}

