/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.executor.etree.relation.join;

import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.impala.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.cloudera.impala.sqlengine.executor.etree.relation.join.ISlaveJoinUnit;
import com.cloudera.impala.sqlengine.executor.etree.temptable.IRowView;
import com.cloudera.impala.sqlengine.executor.etree.temptable.InMemTable;
import com.cloudera.impala.sqlengine.executor.etree.temptable.LongDataStore;
import com.cloudera.impala.sqlengine.executor.etree.temptable.TemporaryFile;
import com.cloudera.impala.sqlengine.utilities.ExternalAlgorithmUtil;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.BitSet;

class InMemJoinUnit
implements ISlaveJoinUnit {
    private static final int LONG_DATA_BUFFER_SIZE = 4096;
    private InMemTable m_table;
    private int m_currentRow;
    private BitSet m_rowTracker;
    private LongDataStore m_longDataStore;
    private boolean[] m_dataNeeded;
    private long m_memoryBalance;
    private boolean m_hasLongData;
    private ExternalAlgorithmUtil.ExternalAlgorithmProperties m_property;

    public InMemJoinUnit(IColumn[] iColumnArray, ExternalAlgorithmUtil.ExternalAlgorithmProperties externalAlgorithmProperties, boolean[] blArray) throws ErrorException {
        this.m_property = externalAlgorithmProperties;
        this.m_table = new InMemTable(iColumnArray, externalAlgorithmProperties.getCellMemoryLimit(), 100, blArray, null);
        this.m_table.setMemLimit(0L);
        this.m_hasLongData = false;
        for (int i = 0; i < iColumnArray.length; ++i) {
            if (!this.m_table.isLongDataColumn(i)) continue;
            this.m_hasLongData = true;
            break;
        }
        this.m_memoryBalance = -this.m_table.getMemOverhead();
        this.m_memoryBalance += this.m_hasLongData ? -externalAlgorithmProperties.getBlockSize() : 0L;
        if (this.m_hasLongData) {
            this.m_longDataStore = this.createLongDataStore();
        }
        this.m_rowTracker = new BitSet();
        this.m_currentRow = -1;
        this.m_dataNeeded = (boolean[])blArray.clone();
    }

    public void reset() throws ErrorException {
        this.m_table.clear();
        this.m_rowTracker.clear();
        this.m_currentRow = -1;
        if (this.m_longDataStore != null) {
            this.m_longDataStore.destroy();
            this.m_longDataStore = null;
        }
        if (this.m_hasLongData) {
            assert (this.m_memoryBalance >= 0L);
            this.m_longDataStore = this.createLongDataStore();
        }
    }

    private LongDataStore createLongDataStore() throws ErrorException {
        return new LongDataStore(this.m_property.getStorageDir(), 4096L, null);
    }

    public void appendRow(ETRelationalExpr eTRelationalExpr) throws ErrorException {
        int n = this.m_table.appendRow();
        if (n < 0) {
            throw new IllegalStateException("Can not append more rows.");
        }
        for (int i = 0; i < eTRelationalExpr.getColumnCount(); ++i) {
            if (!this.m_dataNeeded[i]) continue;
            if (this.m_table.isLongDataColumn(i)) {
                TemporaryFile.FileMarker fileMarker = this.m_longDataStore.put(i, eTRelationalExpr);
                if (fileMarker == null) {
                    this.m_table.setNull(n, i);
                    continue;
                }
                this.m_table.setFileMarker(n, i, fileMarker);
                continue;
            }
            this.m_table.writeData(n, i, eTRelationalExpr);
        }
    }

    public boolean canAppendRow() {
        return this.m_table.canAppendRow();
    }

    @Override
    public void seek(IRowView iRowView) {
        this.m_currentRow = -1;
    }

    @Override
    public boolean retrieveData(int n, ETDataRequest eTDataRequest) throws ErrorException {
        assert (this.m_currentRow >= 0 && this.m_currentRow < this.m_table.getNumRows());
        if (this.m_table.isLongDataColumn(n)) {
            if (this.m_table.isNull(this.m_currentRow, n)) {
                eTDataRequest.getData().setNull();
                return false;
            }
            return this.m_longDataStore.retrieveData(this.m_table.getFileMarker(this.m_currentRow, n), eTDataRequest);
        }
        return this.m_table.retrieveData(this.m_currentRow, n, eTDataRequest);
    }

    @Override
    public boolean moveToNextRow() {
        if (this.m_currentRow < this.m_table.getNumRows() - 1) {
            ++this.m_currentRow;
            return true;
        }
        return false;
    }

    @Override
    public boolean moveOuter() {
        this.m_currentRow = this.m_rowTracker.nextClearBit(this.m_currentRow + 1);
        return this.m_currentRow < this.m_table.getNumRows();
    }

    @Override
    public void setOutputOuter() {
        this.m_currentRow = -1;
    }

    @Override
    public boolean hasOuterRows() {
        return this.m_rowTracker.nextClearBit(0) < this.m_table.getNumRows();
    }

    @Override
    public void match() {
        this.m_rowTracker.set(this.m_currentRow);
    }

    @Override
    public void close() {
        this.m_table.clear();
        if (this.m_longDataStore != null) {
            this.m_longDataStore.destroy();
            this.m_longDataStore = null;
        }
    }

    public long getRequiredMemory() {
        return this.m_table.getRowSize() + (long)this.m_table.getMemOverhead() + (long)(this.m_hasLongData ? 4096 : 0);
    }

    public long reduceMemoryUsage() {
        return this.m_table.reduceMemoryUsage();
    }

    public void assignMemory(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Invalid amount assigned");
        }
        if (this.m_memoryBalance < 0L) {
            this.m_memoryBalance += l;
            l = this.m_memoryBalance;
            if (this.m_memoryBalance > 0L) {
                this.m_memoryBalance = 0L;
            }
        }
        if (l > 0L) {
            this.m_table.increaseMemLimit(l);
        }
    }
}

