/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.executor.etree.value.scalar;

import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.impala.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.impala.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.impala.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.cloudera.impala.support.conv.ConverterConstants;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.List;

public final class ETCurTimestampFn
extends ETScalarFn {
    private final int m_timestampPrecision;
    private final boolean m_isUnary;
    private long m_timeInMillis;

    public ETCurTimestampFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (list.isEmpty() || 1 == list.size());
        assert (93 == iColumn.getTypeMetadata().getType());
        short s = iColumn.getTypeMetadata().getPrecision();
        assert (s >= 0) : "negative precision";
        this.m_isUnary = !list.isEmpty();
        this.m_timestampPrecision = Math.min(s, 3);
    }

    @Override
    public void open() throws ErrorException {
        super.open();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        long l = gregorianCalendar.getTimeInMillis();
        l -= l % (long)ConverterConstants.MILLIS_MOD[this.m_timestampPrecision];
        this.m_timeInMillis = l;
    }

    @Override
    public String getLogString() {
        return "ETCurTimestampFn";
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        assert (this.isOpen());
        if (this.m_isUnary) {
            ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
            if (iSqlDataWrapper.isNull()) {
                eTDataRequest.getData().setNull();
            } else {
                int n = Math.max((int)iSqlDataWrapper.getInteger(), 0);
                long l = this.m_timeInMillis;
                if (n < this.m_timestampPrecision) {
                    l -= l % (long)ConverterConstants.MILLIS_MOD[n];
                }
                Timestamp timestamp = new Timestamp(l);
                eTDataRequest.getData().setTimestamp(timestamp);
            }
        } else {
            Timestamp timestamp = new Timestamp(this.m_timeInMillis);
            eTDataRequest.getData().setTimestamp(timestamp);
        }
        return false;
    }
}

