/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.support.channels;

import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogLevel;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.channels.AbstractSocketChannel;
import com.cloudera.impala.support.channels.ISocketChannelReadCallback;
import com.cloudera.impala.support.channels.SocketChannelMessageKey;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;

public class PlainSocketChannel
extends AbstractSocketChannel {
    protected static final int READ_BUFFER_CAPACITY = 512000;
    private ByteBuffer m_readBuffer = ByteBuffer.allocateDirect(512000);

    public PlainSocketChannel(SocketChannel socketChannel, ISocketChannelReadCallback iSocketChannelReadCallback, ILogger iLogger) throws ErrorException {
        super(socketChannel, iSocketChannelReadCallback, iLogger);
        this.m_readBuffer.order(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public boolean write(ByteBuffer byteBuffer) throws ErrorException {
        return this.write(new ByteBuffer[]{byteBuffer}, 0, 1);
    }

    @Override
    public boolean write(ByteBuffer[] byteBufferArray, int n, int n2) throws ErrorException {
        if (null == this.m_internal || this.isClosed()) {
            throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_SERVER_CLOSED.name());
        }
        long l = 0L;
        while (this.arrayHasRemaining(byteBufferArray, n, n2)) {
            try {
                l = this.m_internal.write(byteBufferArray, n, n2);
                if (LogUtilities.shouldLogLevel(LogLevel.TRACE, this.m_log)) {
                    LogUtilities.logTrace(String.format("%d bytes written to channel %s", l, this.getChannelID()), this.m_log);
                }
                if (0L != l) continue;
                return true;
            }
            catch (IOException iOException) {
                String string;
                if (LogUtilities.shouldLogLevel(LogLevel.DEBUG, this.m_log)) {
                    LogUtilities.logDebug(String.format("Error occurred while writing on channel %s: %s", this.getChannelID(), iOException), this.m_log);
                }
                if (null != (string = iOException.getMessage())) {
                    throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), string, (Throwable)iOException);
                }
                throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_SERVER_CLOSED.name(), (Throwable)iOException);
            }
        }
        return true;
    }

    @Override
    public void read() throws ErrorException {
        int n = -2;
        do {
            try {
                n = this.m_internal.read(this.m_readBuffer);
            }
            catch (IOException iOException) {
                String string;
                if (LogUtilities.shouldLogLevel(LogLevel.FATAL, this.m_log)) {
                    LogUtilities.logFatal(String.format("Error occurred while reading on channel %s: %s", this.getChannelID(), iOException), this.m_log);
                }
                if (null != (string = iOException.getMessage())) {
                    throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), string, (Throwable)iOException);
                }
                throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_SERVER_CLOSED.name(), (Throwable)iOException);
            }
            if (LogUtilities.shouldLogLevel(LogLevel.TRACE, this.m_log)) {
                LogUtilities.logTrace(String.format("%d bytes read from channel %s", n, this.getChannelID()), this.m_log);
            }
            if (-1 != n) continue;
            this.readCallback(this.m_readBuffer);
            throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_SERVER_CLOSED.name());
        } while (n > 0);
        this.readCallback(this.m_readBuffer);
    }

    @Override
    public int getReadBufferCapacity() {
        return 512000;
    }
}

